/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.context.annotation;

import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.core.config.AmazonWebserviceClientConfigurationUtils;
import java.util.List;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;

public class OnMissingAmazonClientCondition
implements Condition {
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnMissingAmazonClient.class.getName(), true);
        for (Object amazonClientClass : (List)attributes.get((Object)"value")) {
            if (!this.isAmazonClientMissing(context, (String)amazonClientClass)) continue;
            return true;
        }
        return false;
    }

    private boolean isAmazonClientMissing(ConditionContext context, String amazonClientClass) {
        String amazonClientBeanName = AmazonWebserviceClientConfigurationUtils.getBeanName((String)amazonClientClass);
        return !context.getBeanFactory().containsBean(amazonClientBeanName) && !context.getRegistry().containsBeanDefinition(amazonClientBeanName);
    }
}

