/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import io.awspring.cloud.autoconfigure.paramstore.AwsParamStoreConfigDataResource;
import io.awspring.cloud.paramstore.AwsParamStorePropertySource;
import java.util.Collections;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;

public class AwsParamStoreConfigDataLoader
implements ConfigDataLoader<AwsParamStoreConfigDataResource> {
    public ConfigData load(ConfigDataLoaderContext context, AwsParamStoreConfigDataResource resource) {
        try {
            AWSSimpleSystemsManagement ssm = (AWSSimpleSystemsManagement)context.getBootstrapContext().get(AWSSimpleSystemsManagement.class);
            AwsParamStorePropertySource propertySource = resource.getPropertySources().createPropertySource(resource.getContext(), resource.isOptional(), ssm);
            if (propertySource != null) {
                return new ConfigData(Collections.singletonList(propertySource), new ConfigData.Option[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigDataResourceNotFoundException((ConfigDataResource)resource, (Throwable)e);
        }
    }
}

