/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import io.awspring.cloud.autoconfigure.paramstore.AwsParamStoreBootstrapConfiguration;
import io.awspring.cloud.autoconfigure.paramstore.AwsParamStoreConfigDataResource;
import io.awspring.cloud.paramstore.AwsParamStoreProperties;
import io.awspring.cloud.paramstore.AwsParamStorePropertySources;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.BootstrapContext;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.util.StringUtils;

public class AwsParamStoreConfigDataLocationResolver
implements ConfigDataLocationResolver<AwsParamStoreConfigDataResource> {
    public static final String PREFIX = "aws-parameterstore:";
    private final Log log = LogFactory.getLog(AwsParamStoreConfigDataLocationResolver.class);

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        if (!location.hasPrefix(PREFIX)) {
            return false;
        }
        return (Boolean)context.getBinder().bind("aws.paramstore.enabled", Boolean.class).orElse((Object)true);
    }

    public List<AwsParamStoreConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException {
        return Collections.emptyList();
    }

    public List<AwsParamStoreConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext resolverContext, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        this.registerBean(resolverContext, AwsParamStoreProperties.class, this.loadProperties(resolverContext.getBinder()));
        this.registerAndPromoteBean(resolverContext, AWSSimpleSystemsManagement.class, this::createSimpleSystemManagementClient);
        AwsParamStoreProperties properties = this.loadConfigProperties(resolverContext.getBinder());
        AwsParamStorePropertySources sources = new AwsParamStorePropertySources(properties, this.log);
        List<String> contexts = location.getValue().equals(PREFIX) ? sources.getAutomaticContexts(profiles.getAccepted()) : this.getCustomContexts(location.getNonPrefixedValue(PREFIX));
        ArrayList<AwsParamStoreConfigDataResource> locations = new ArrayList<AwsParamStoreConfigDataResource>();
        contexts.forEach(propertySourceContext -> locations.add(new AwsParamStoreConfigDataResource((String)propertySourceContext, location.isOptional(), sources)));
        return locations;
    }

    private List<String> getCustomContexts(String keys) {
        if (StringUtils.hasLength((String)keys)) {
            return Arrays.asList(keys.split(";"));
        }
        return Collections.emptyList();
    }

    protected <T> void registerAndPromoteBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        this.registerBean(context, type, supplier);
        context.getBootstrapContext().addCloseListener(event -> {
            Object instance = event.getBootstrapContext().get(type);
            event.getApplicationContext().getBeanFactory().registerSingleton("configData" + type.getSimpleName(), instance);
        });
    }

    public <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, T instance) {
        context.getBootstrapContext().registerIfAbsent(type, BootstrapRegistry.InstanceSupplier.of(instance));
    }

    protected <T> void registerBean(ConfigDataLocationResolverContext context, Class<T> type, BootstrapRegistry.InstanceSupplier<T> supplier) {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        bootstrapContext.registerIfAbsent(type, supplier);
    }

    protected AWSSimpleSystemsManagement createSimpleSystemManagementClient(BootstrapContext context) {
        AwsParamStoreProperties properties = (AwsParamStoreProperties)context.get(AwsParamStoreProperties.class);
        return AwsParamStoreBootstrapConfiguration.createSimpleSystemManagementClient(properties);
    }

    protected AwsParamStoreProperties loadProperties(Binder binder) {
        return (AwsParamStoreProperties)binder.bind("aws.paramstore", Bindable.of(AwsParamStoreProperties.class)).orElseGet(AwsParamStoreProperties::new);
    }

    protected AwsParamStoreProperties loadConfigProperties(Binder binder) {
        AwsParamStoreProperties properties = (AwsParamStoreProperties)binder.bind("aws.paramstore", Bindable.of(AwsParamStoreProperties.class)).orElseGet(AwsParamStoreProperties::new);
        if (!StringUtils.hasLength((String)properties.getName())) {
            properties.setName((String)binder.bind("spring.application.name", String.class).orElse((Object)"application"));
        }
        return properties;
    }
}

