/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.axoniq.axonserver.connector.ErrorCategory;
import io.axoniq.axonserver.connector.ReplyChannel;
import io.axoniq.axonserver.grpc.ErrorMessage;
import io.axoniq.axonserver.grpc.InstructionResult;
import io.grpc.stub.StreamObserver;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class ForwardingReplyChannel<T>
implements ReplyChannel<T> {
    private final AtomicBoolean resultSent = new AtomicBoolean(false);
    private final String instructionId;
    private final String clientId;
    private final StreamObserver<T> stream;
    private final Function<InstructionResult, Optional<T>> resultBuilder;
    private final Runnable onConsumed;
    private final AtomicBoolean completed = new AtomicBoolean();

    public ForwardingReplyChannel(String instructionId, String clientId, StreamObserver<T> stream, Function<InstructionResult, Optional<T>> resultBuilder, Runnable onComplete) {
        this.instructionId = instructionId;
        this.clientId = clientId;
        this.stream = stream;
        this.resultBuilder = resultBuilder;
        this.onConsumed = onComplete;
    }

    @Override
    public void send(T outboundMessage) {
        this.stream.onNext(outboundMessage);
    }

    private void ackSuccess() {
        if (this.instructionId != null && !this.instructionId.isEmpty() && this.resultSent.compareAndSet(false, true)) {
            this.resultBuilder.apply(InstructionResult.newBuilder().setInstructionId(this.instructionId).setSuccess(true).build()).ifPresent(arg_0 -> this.stream.onNext(arg_0));
        }
    }

    @Override
    public void complete() {
        this.ackSuccess();
        this.markConsumed();
    }

    @Override
    public void completeWithError(ErrorMessage errorMessage) {
        this.ackFailure(errorMessage);
        this.markConsumed();
    }

    private void ackFailure(ErrorMessage errorMessage) {
        if (this.instructionId != null && !this.instructionId.isEmpty() && this.resultSent.compareAndSet(false, true)) {
            if (errorMessage.getLocation().isEmpty()) {
                errorMessage = errorMessage.toBuilder().setLocation(this.clientId).build();
            }
            InstructionResult failure = InstructionResult.newBuilder().setInstructionId(this.instructionId).setError(errorMessage == null ? ErrorMessage.getDefaultInstance() : errorMessage).setSuccess(false).build();
            this.resultBuilder.apply(failure).ifPresent(arg_0 -> this.stream.onNext(arg_0));
        }
    }

    @Override
    public void completeWithError(ErrorCategory errorCategory, String message) {
        this.completeWithError(ErrorMessage.newBuilder().setErrorCode(errorCategory.errorCode()).setLocation(this.clientId).setMessage(message).build());
    }

    private void markConsumed() {
        if (this.completed.compareAndSet(false, true)) {
            this.onConsumed.run();
        }
    }
}

