/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

public class HeaderAttachingInterceptor<T>
implements ClientInterceptor {
    private final Metadata.Key<T> header;
    private final T value;

    public HeaderAttachingInterceptor(Metadata.Key<T> header, T value) {
        this.header = header;
        this.value = value;
    }

    public <REQ, RESP> ClientCall<REQ, RESP> interceptCall(MethodDescriptor<REQ, RESP> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall call = channel.newCall(methodDescriptor, callOptions);
        return this.value == null ? call : new HeaderAttachedCall(call);
    }

    private class HeaderAttachedCall<REQ, RESP>
    extends ForwardingClientCall.SimpleForwardingClientCall<REQ, RESP> {
        public HeaderAttachedCall(ClientCall<REQ, RESP> call) {
            super(call);
        }

        public void start(ClientCall.Listener<RESP> responseListener, Metadata headers) {
            headers.put(HeaderAttachingInterceptor.this.header, HeaderAttachingInterceptor.this.value);
            super.start(responseListener, headers);
        }
    }
}

