/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.impl.buffer;

import io.axoniq.axonserver.connector.impl.CloseableBuffer;
import io.axoniq.axonserver.grpc.ErrorMessage;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;

public class BlockingCloseableBuffer<T>
implements CloseableBuffer<T> {
    private static final int DEFAULT_CAPACITY = 32;
    private final BlockingQueue<T> buffer = new LinkedBlockingQueue<T>(32);
    private volatile boolean closed = false;
    private final AtomicReference<ErrorMessage> errorRef = new AtomicReference();
    private final AtomicReference<Runnable> onAvailableRef = new AtomicReference();

    @Override
    public Optional<T> poll() {
        return Optional.ofNullable(this.buffer.poll());
    }

    @Override
    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    @Override
    public int capacity() {
        return 32;
    }

    public int size() {
        return this.buffer.size();
    }

    @Override
    public void onAvailable(Runnable onAvailable) {
        this.onAvailableRef.set(onAvailable);
        if (!this.isEmpty() || this.closed) {
            this.notifyOnAvailable();
        }
    }

    @Override
    public void put(T message) {
        try {
            this.buffer.put(message);
            this.notifyOnAvailable();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    public Optional<ErrorMessage> error() {
        return Optional.ofNullable(this.errorRef.get());
    }

    @Override
    public void close() {
        this.closed = true;
        this.notifyOnAvailable();
    }

    @Override
    public void closeExceptionally(ErrorMessage errorMessage) {
        this.errorRef.set(errorMessage);
        this.close();
    }

    protected void notifyOnAvailable() {
        Runnable onAvailable = this.onAvailableRef.get();
        if (onAvailable != null) {
            onAvailable.run();
        }
    }
}

