/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.axonserver.connector.query.impl;

import io.axoniq.axonserver.connector.impl.AbstractBufferedStream;
import io.axoniq.axonserver.grpc.FlowControl;
import io.axoniq.axonserver.grpc.query.QueryUpdate;
import io.axoniq.axonserver.grpc.query.SubscriptionQuery;
import io.axoniq.axonserver.grpc.query.SubscriptionQueryRequest;
import java.util.concurrent.atomic.AtomicBoolean;

public class SubscriptionQueryUpdateBuffer
extends AbstractBufferedStream<QueryUpdate, SubscriptionQueryRequest> {
    private static final QueryUpdate TERMINAL_MESSAGE = QueryUpdate.newBuilder().setClientId("__terminal__").build();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final String subscriptionQueryId;
    private final int refillBatch;
    private final SubscriptionQueryRequest refillRequest;

    public SubscriptionQueryUpdateBuffer(String clientId, String subscriptionQueryId, int bufferSize, int refillBatch) {
        super(clientId, bufferSize, refillBatch);
        this.subscriptionQueryId = subscriptionQueryId;
        this.refillBatch = refillBatch;
        this.refillRequest = SubscriptionQueryRequest.newBuilder().setFlowControl(SubscriptionQuery.newBuilder().setNumberOfPermits(refillBatch).build()).build();
    }

    @Override
    protected QueryUpdate terminalMessage() {
        return TERMINAL_MESSAGE;
    }

    @Override
    protected SubscriptionQueryRequest buildFlowControlMessage(FlowControl flowControl) {
        if ((long)this.refillBatch == flowControl.getPermits()) {
            return this.refillRequest;
        }
        return SubscriptionQueryRequest.newBuilder().setFlowControl(SubscriptionQuery.newBuilder().setNumberOfPermits(flowControl.getPermits()).build()).build();
    }

    @Override
    public void onNext(QueryUpdate value) {
        if (!this.closed.get()) {
            super.onNext(value);
        }
    }

    @Override
    public void onError(Throwable t) {
        try {
            super.onError(t);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void onCompleted() {
        try {
            super.onCompleted();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            SubscriptionQuery subscriptionQueryToUnsubscribe = SubscriptionQuery.newBuilder().setSubscriptionIdentifier(this.subscriptionQueryId).build();
            this.outboundStream().onNext((Object)SubscriptionQueryRequest.newBuilder().setUnsubscribe(subscriptionQueryToUnsubscribe).build());
            this.onCompleted();
            this.outboundStream().onCompleted();
        }
    }
}

