/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import io.bootique.BQModuleProvider;
import io.bootique.BQRuntime;
import io.bootique.meta.module.ModuleMetadata;
import io.bootique.meta.module.ModulesMetadata;
import io.bootique.test.junit.BQTestFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.junit.Assert;

public class BQModuleProviderChecker {
    private Class<? extends BQModuleProvider> provider;

    protected BQModuleProviderChecker(Class<? extends BQModuleProvider> provider) {
        this.provider = Objects.requireNonNull(provider);
    }

    public static void testAutoLoadable(Class<? extends BQModuleProvider> provider) {
        new BQModuleProviderChecker(provider).testAutoLoadable();
    }

    public static void testMetadata(Class<? extends BQModuleProvider> provider) {
        new BQModuleProviderChecker(provider).testMetadata();
    }

    protected Stream<BQModuleProvider> matchingProviders() {
        return StreamSupport.stream(ServiceLoader.load(BQModuleProvider.class).spliterator(), false).filter(p -> p != null && this.provider.equals(p.getClass()));
    }

    protected BQModuleProvider matchingProvider() {
        return this.matchingProviders().findFirst().get();
    }

    protected void testAutoLoadable() {
        Long c = this.matchingProviders().collect(Collectors.counting());
        switch (c.intValue()) {
            case 0: {
                Assert.fail((String)("Expected provider '" + this.provider.getName() + "' is not found"));
                break;
            }
            case 1: {
                break;
            }
            default: {
                Assert.fail((String)("Expected provider '" + this.provider.getName() + "' is found more then once: " + c));
            }
        }
    }

    protected void testMetadata() {
        this.testWithFactory(testFactory -> {
            BQRuntime runtime = ((BQTestFactory.Builder)testFactory.app(new String[0]).autoLoadModules()).createRuntime();
            BQModuleProvider provider = this.matchingProvider();
            String providerName = provider.name();
            Optional<ModuleMetadata> moduleMetadata = ((ModulesMetadata)runtime.getInstance(ModulesMetadata.class)).getModules().stream().filter(mmd -> providerName.equals(mmd.getProviderName())).findFirst();
            Assert.assertTrue((String)("No module metadata available for provider: '" + providerName + "'"), (boolean)moduleMetadata.isPresent());
            moduleMetadata.get().getConfigs();
        });
    }

    protected void testWithFactory(Consumer<BQTestFactory> test) {
        BQTestFactory testFactory = new BQTestFactory();
        try {
            testFactory.before();
            test.accept(testFactory);
        }
        finally {
            testFactory.after();
        }
    }
}

