/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import com.google.inject.Module;
import io.bootique.BQRuntime;
import io.bootique.meta.module.ModuleMetadata;
import io.bootique.meta.module.ModulesMetadata;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;

public class BQRuntimeChecker {
    @SafeVarargs
    public static void testModulesLoaded(BQRuntime runtime, Class<? extends Module> ... expectedModules) {
        ModulesMetadata modulesMetadata = (ModulesMetadata)runtime.getInstance(ModulesMetadata.class);
        List actualModules = modulesMetadata.getModules().stream().map(ModuleMetadata::getName).collect(Collectors.toList());
        Object[] expectedModuleNames = (String[])Stream.of(expectedModules).map(Class::getSimpleName).toArray(String[]::new);
        Assert.assertThat(actualModules, (Matcher)IsCollectionContaining.hasItems((Object[])expectedModuleNames));
    }
}

