/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.bootique.BQCoreModule;
import io.bootique.BQModuleOverrideBuilder;
import io.bootique.BQModuleProvider;
import io.bootique.Bootique;
import io.bootique.log.BootLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class BQTestRuntimeBuilder<T extends BQTestRuntimeBuilder<T>> {
    protected Bootique bootique;
    protected Map<String, String> properties;
    private static final String EXCLUDE_SYSTEM_VARIABLES = "bq.core.excludeSystemVariables";
    private static final String EXCLUDE_SYSTEM_PROPERTIES = "bq.core.excludeSystemProperties";

    protected BQTestRuntimeBuilder(String[] args) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(EXCLUDE_SYSTEM_PROPERTIES, "true");
        properties.put(EXCLUDE_SYSTEM_VARIABLES, "true");
        this.properties = properties;
        this.bootique = Bootique.app((String[])args).module(this.createPropertiesProvider());
    }

    protected BQModuleProvider createPropertiesProvider() {
        return new BQModuleProvider(){

            public Module module() {
                return binder -> BQCoreModule.extend((Binder)binder).setProperties(BQTestRuntimeBuilder.this.properties);
            }

            public String name() {
                return "BQTestRuntimeBuilder:properties";
            }
        };
    }

    public T args(String ... args) {
        this.bootique.args(args);
        return (T)this;
    }

    public T args(Collection<String> args) {
        this.bootique.args(args);
        return (T)this;
    }

    public T autoLoadModules() {
        this.bootique.autoLoadModules();
        return (T)this;
    }

    public T bootLogger(BootLogger bootLogger) {
        this.bootique.bootLogger(bootLogger);
        return (T)this;
    }

    public T module(Class<? extends Module> moduleType) {
        this.bootique.module(moduleType);
        return (T)this;
    }

    @SafeVarargs
    public final T modules(Class<? extends Module> ... moduleTypes) {
        this.bootique.modules((Class[])moduleTypes);
        return (T)this;
    }

    public T module(Module m) {
        this.bootique.module(m);
        return (T)this;
    }

    public T modules(Module ... modules) {
        this.bootique.modules(modules);
        return (T)this;
    }

    public T module(BQModuleProvider moduleProvider) {
        this.bootique.module(moduleProvider);
        return (T)this;
    }

    public BQModuleOverrideBuilder<T> override(Class<? extends Module> ... overriddenTypes) {
        final BQModuleOverrideBuilder subBuilder = this.bootique.override((Class[])overriddenTypes);
        return new BQModuleOverrideBuilder<T>(){

            public T with(Class<? extends Module> moduleType) {
                subBuilder.with(moduleType);
                return BQTestRuntimeBuilder.this;
            }

            public T with(Module module) {
                subBuilder.with(module);
                return BQTestRuntimeBuilder.this;
            }
        };
    }

    public T property(String key, String value) {
        this.properties.put(key, value);
        return (T)this;
    }
}

