/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.bootique.config.PolymorphicConfiguration;
import io.bootique.config.TypesFactory;
import io.bootique.log.BootLogger;
import io.bootique.log.DefaultBootLogger;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;

public class PolymorphicConfigurationChecker<T extends PolymorphicConfiguration> {
    private Class<T> expectedRoot;
    private Class<? extends T> expectedDefault;
    private Set<Class<? extends T>> allExpectedTypes;

    @SafeVarargs
    protected PolymorphicConfigurationChecker(Class<T> expectedRoot, Class<? extends T> expectedDefault, Class<? extends T> ... otherConfigs) {
        this.expectedRoot = Objects.requireNonNull(expectedRoot);
        this.expectedDefault = expectedDefault;
        HashSet<Class<T>> allTypes = new HashSet<Class<T>>();
        allTypes.add(Objects.requireNonNull(expectedRoot));
        if (expectedDefault != null) {
            allTypes.add(expectedDefault);
        }
        if (otherConfigs != null) {
            for (Class<? extends T> c : otherConfigs) {
                allTypes.add(c);
            }
        }
        this.allExpectedTypes = allTypes;
    }

    @SafeVarargs
    public static <T extends PolymorphicConfiguration> void test(Class<T> expectedRoot, Class<? extends T> expectedDefault, Class<? extends T> ... otherConfigs) {
        new PolymorphicConfigurationChecker<T>(expectedRoot, expectedDefault, otherConfigs).test();
    }

    @SafeVarargs
    public static <T extends PolymorphicConfiguration> void testNoDefault(Class<T> expectedRoot, Class<? extends T> ... otherConfigs) {
        new PolymorphicConfigurationChecker<T>(expectedRoot, null, otherConfigs).test();
    }

    protected void test() {
        Set<Class<PolymorphicConfiguration>> loaded = this.loadedFromSpi();
        Assert.assertEquals((String)"Loaded and expected types do not match", this.allExpectedTypes, loaded);
        this.testRoot();
        this.allExpectedTypes.forEach(t -> {
            if (!t.equals(this.expectedRoot)) {
                this.testNonRoot((Class<? extends T>)t);
            }
        });
    }

    protected void testRoot() {
        Assert.assertTrue((String)("Invalid root type: " + this.expectedRoot), (boolean)PolymorphicConfiguration.class.isAssignableFrom(this.expectedRoot));
        JsonTypeInfo typeInfo = this.expectedRoot.getAnnotation(JsonTypeInfo.class);
        Assert.assertNotNull((String)"Root is not annotated with @JsonTypeInfo", (Object)typeInfo);
        if (this.expectedDefault != null) {
            Assert.assertTrue((String)("Default type is not specified on root. Expected: " + this.expectedDefault.getName()), (boolean)this.hasDefault(typeInfo));
            Assert.assertEquals((String)"Expected and actual default types are not the same", this.expectedDefault, (Object)typeInfo.defaultImpl());
        } else {
            Assert.assertFalse((String)("Expected no default type, but @JsonTypeInfo sets it to " + typeInfo.defaultImpl().getName() + "."), (boolean)this.hasDefault(typeInfo));
        }
        if (this.isConcrete(this.expectedRoot)) {
            JsonTypeName typeName = this.expectedRoot.getAnnotation(JsonTypeName.class);
            Assert.assertNotNull((String)("Concrete root configuration type must be annotated with @JsonTypeName: " + this.expectedRoot.getName()), (Object)typeName);
        }
    }

    protected void testNonRoot(Class<? extends T> t) {
        Assert.assertTrue((String)("Invalid type " + t.getName() + ". Must be a subclass of root type " + this.expectedRoot.getName()), (boolean)this.expectedRoot.isAssignableFrom(t));
        Assert.assertTrue((String)("Non-root configuration type must not be abstract: " + t.getName()), (boolean)this.isConcrete(t));
        JsonTypeName typeName = t.getAnnotation(JsonTypeName.class);
        Assert.assertNotNull((String)("Non-root configuration type must be annotated with @JsonTypeName: " + t.getName()), (Object)typeName);
    }

    protected Set<Class<? extends PolymorphicConfiguration>> loadedFromSpi() {
        Collection types;
        try {
            types = new TypesFactory(this.getClass().getClassLoader(), PolymorphicConfiguration.class, (BootLogger)new DefaultBootLogger(false)).getTypes();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
            throw new RuntimeException(e);
        }
        return types.stream().filter(p -> this.expectedRoot.isAssignableFrom((Class<?>)p)).collect(Collectors.toSet());
    }

    protected boolean isConcrete(Class<?> type) {
        int modifiers = type.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers);
    }

    protected boolean hasDefault(JsonTypeInfo typeInfo) {
        return !typeInfo.defaultImpl().equals(JsonTypeInfo.class);
    }
}

