/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jersey;

import io.bootique.annotation.BQConfig;
import io.bootique.annotation.BQConfigProperty;
import io.bootique.jetty.MappedServlet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Servlet;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

@BQConfig(value="Configures the servlet that is an entry point to Jersey REST API engine.")
public class JerseyServletFactory {
    protected String urlPattern;

    @BQConfigProperty
    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public JerseyServletFactory initUrlPatternIfNotSet(String urlPattern) {
        if (this.urlPattern == null) {
            this.urlPattern = urlPattern;
        }
        return this;
    }

    public MappedServlet<ServletContainer> createJerseyServlet(ResourceConfig resourceConfig) {
        ServletContainer servlet = new ServletContainer(resourceConfig);
        Set<String> urlPatterns = Collections.singleton(Objects.requireNonNull(this.urlPattern));
        return new MappedServlet((Servlet)servlet, urlPatterns, "jersey");
    }
}

