/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.bootique.ModuleExtender;
import io.bootique.jetty.MappedFilter;
import io.bootique.jetty.MappedListener;
import io.bootique.jetty.MappedServlet;
import io.bootique.jetty.server.ServletContextHandlerExtender;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.DefaultServlet;

public class JettyModuleExtender
extends ModuleExtender<JettyModuleExtender> {
    private Multibinder<Filter> filters;
    private Multibinder<Servlet> servlets;
    private Multibinder<EventListener> listeners;
    private Multibinder<MappedFilter> mappedFilters;
    private Multibinder<MappedServlet> mappedServlets;
    private Multibinder<MappedListener> mappedListeners;
    private Multibinder<ServletContextHandlerExtender> contextHandlerExtenders;

    public JettyModuleExtender(Binder binder) {
        super(binder);
    }

    public JettyModuleExtender initAllExtensions() {
        this.contributeFilters();
        this.contributeServlets();
        this.contributeListeners();
        this.contributeMappedFilters();
        this.contributeMappedServlets();
        this.contributeMappedListeners();
        this.contributeContextHandlerExtenders();
        return this;
    }

    public JettyModuleExtender addListener(EventListener listener) {
        this.contributeListeners().addBinding().toInstance((Object)listener);
        return this;
    }

    public JettyModuleExtender addListener(Class<? extends EventListener> listenerType) {
        this.contributeListeners().addBinding().to(listenerType);
        return this;
    }

    public <T extends EventListener> JettyModuleExtender addMappedListener(MappedListener<T> mappedListener) {
        this.contributeMappedListeners().addBinding().toInstance(mappedListener);
        return this;
    }

    public <T extends EventListener> JettyModuleExtender addMappedListener(Key<MappedListener<T>> mappedListenerKey) {
        this.contributeMappedListeners().addBinding().to(mappedListenerKey);
        return this;
    }

    public <T extends EventListener> JettyModuleExtender addMappedListener(TypeLiteral<MappedListener<T>> mappedListenerType) {
        return this.addMappedListener(Key.get(mappedListenerType));
    }

    public JettyModuleExtender addStaticServlet(String name, String ... urlPatterns) {
        return this.addServlet((Servlet)new DefaultServlet(), name, urlPatterns);
    }

    public JettyModuleExtender useDefaultServlet() {
        return this.addStaticServlet("default", "/");
    }

    public JettyModuleExtender addServlet(Class<? extends Servlet> servletType) {
        this.contributeServlets().addBinding().to(servletType);
        return this;
    }

    public JettyModuleExtender addServlet(Servlet servlet, String name, String ... urlPatterns) {
        HashSet<String> urlPatternsSet = new HashSet<String>();
        if (urlPatterns != null) {
            Collections.addAll(urlPatternsSet, urlPatterns);
        }
        return this.addMappedServlet(new MappedServlet<Servlet>(servlet, urlPatternsSet, name));
    }

    public <T extends Servlet> JettyModuleExtender addMappedServlet(MappedServlet<T> mappedServlet) {
        this.contributeMappedServlets().addBinding().toInstance(mappedServlet);
        return this;
    }

    public <T extends Servlet> JettyModuleExtender addMappedServlet(Key<MappedServlet<T>> mappedServletKey) {
        this.contributeMappedServlets().addBinding().to(mappedServletKey);
        return this;
    }

    public <T extends Servlet> JettyModuleExtender addMappedServlet(TypeLiteral<MappedServlet<T>> mappedServletType) {
        return this.addMappedServlet(Key.get(mappedServletType));
    }

    public JettyModuleExtender addFilter(Class<? extends Filter> filterType) {
        this.contributeFilters().addBinding().to(filterType);
        return this;
    }

    public JettyModuleExtender addFilter(Filter filter, String name, int order, String ... urlPatterns) {
        HashSet<String> urlPatternsSet = new HashSet<String>();
        if (urlPatterns != null) {
            Collections.addAll(urlPatternsSet, urlPatterns);
        }
        return this.addMappedFilter(new MappedFilter<Filter>(filter, urlPatternsSet, name, order));
    }

    public <T extends Filter> JettyModuleExtender addMappedFilter(MappedFilter<T> mappedFilter) {
        this.contributeMappedFilters().addBinding().toInstance(mappedFilter);
        return this;
    }

    public <T extends Filter> JettyModuleExtender addMappedFilter(Key<MappedFilter<T>> mappedFilterKey) {
        this.contributeMappedFilters().addBinding().to(mappedFilterKey);
        return this;
    }

    public <T extends Filter> JettyModuleExtender addMappedFilter(TypeLiteral<MappedFilter<T>> mappedFilterType) {
        return this.addMappedFilter(Key.get(mappedFilterType));
    }

    public JettyModuleExtender addContextHandlerExtender(ServletContextHandlerExtender extender) {
        this.contributeContextHandlerExtenders().addBinding().toInstance((Object)extender);
        return this;
    }

    public JettyModuleExtender addContextHandlerExtender(Class<? extends ServletContextHandlerExtender> type) {
        this.contributeContextHandlerExtenders().addBinding().to(type);
        return this;
    }

    protected Multibinder<Filter> contributeFilters() {
        return this.filters != null ? this.filters : (this.filters = this.newSet(Filter.class));
    }

    protected Multibinder<Servlet> contributeServlets() {
        return this.servlets != null ? this.servlets : (this.servlets = this.newSet(Servlet.class));
    }

    protected Multibinder<EventListener> contributeListeners() {
        return this.listeners != null ? this.listeners : (this.listeners = this.newSet(EventListener.class));
    }

    protected Multibinder<MappedFilter> contributeMappedFilters() {
        return this.mappedFilters != null ? this.mappedFilters : (this.mappedFilters = this.newSet(MappedFilter.class));
    }

    protected Multibinder<MappedServlet> contributeMappedServlets() {
        return this.mappedServlets != null ? this.mappedServlets : (this.mappedServlets = this.newSet(MappedServlet.class));
    }

    protected Multibinder<MappedListener> contributeMappedListeners() {
        return this.mappedListeners != null ? this.mappedListeners : (this.mappedListeners = this.newSet(MappedListener.class));
    }

    protected Multibinder<ServletContextHandlerExtender> contributeContextHandlerExtenders() {
        return this.contextHandlerExtenders != null ? this.contextHandlerExtenders : (this.contextHandlerExtenders = this.newSet(ServletContextHandlerExtender.class));
    }
}

