/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.jetty.MappedServlet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;

public class MappedServletFactory {
    public MappedServlet toMappedServlet(Servlet servlet) {
        WebServlet wsAnnotation = servlet.getClass().getAnnotation(WebServlet.class);
        if (wsAnnotation == null) {
            throw new IllegalArgumentException("Servlet contains no @WebServlet annotation and can not be mapped directly. Wrap it in a MappedServlet instead.");
        }
        String name = wsAnnotation.name() != null && wsAnnotation.name().length() > 0 ? wsAnnotation.name() : null;
        HashSet<String> urlPatterns = new HashSet<String>(Arrays.asList(wsAnnotation.urlPatterns()));
        HashMap<String, String> initParams = new HashMap<String, String>();
        WebInitParam[] paramsArray = wsAnnotation.initParams();
        if (paramsArray != null) {
            Arrays.asList(paramsArray).forEach(p -> initParams.put(p.name(), p.value()));
        }
        return new MappedServlet<Servlet>(servlet, urlPatterns, name, initParams);
    }
}

