/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import io.bootique.jetty.server.ConnectorDescriptor;
import java.util.Collection;
import java.util.stream.Collectors;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLifecycleLogger
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLifecycleLogger.class);
    private Collection<ConnectorDescriptor> connectorDescriptors;
    private String context;
    private long t0;

    public ServerLifecycleLogger(Collection<ConnectorDescriptor> connectorDescriptors, String context) {
        this.connectorDescriptors = connectorDescriptors;
        this.context = context;
    }

    public void lifeCycleStarting(LifeCycle event) {
        this.t0 = System.currentTimeMillis();
        LOGGER.info("Starting jetty...");
    }

    public void lifeCycleStarted(LifeCycle event) {
        long t1 = System.currentTimeMillis();
        if (this.connectorDescriptors.isEmpty()) {
            LOGGER.info("Started Jetty in {} ms. No connectors configured", (Object)(t1 - this.t0));
        }
        if (this.connectorDescriptors.size() == 1) {
            String url = this.connectorDescriptors.iterator().next().getUrl(this.context);
            LOGGER.info("Started Jetty in {} ms. Base URL: {}", (Object)(t1 - this.t0), (Object)url);
        } else {
            String urls = this.connectorDescriptors.stream().map(cd -> cd.getUrl(this.context)).collect(Collectors.joining(", "));
            LOGGER.info("Started Jetty in {} ms. Base URLs: {}", (Object)(t1 - this.t0), (Object)urls);
        }
    }
}

