/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.logback;

import ch.qos.logback.classic.Logger;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.bootique.ConfigModule;
import io.bootique.annotation.LogLevels;
import io.bootique.config.ConfigurationFactory;
import io.bootique.logback.LogbackContextFactory;
import io.bootique.shutdown.ShutdownManager;
import java.util.Map;
import java.util.logging.Level;

public class LogbackModule
extends ConfigModule {
    public LogbackModule(String configPrefix) {
        super(configPrefix);
    }

    public LogbackModule() {
    }

    protected String defaultConfigPrefix() {
        return "log";
    }

    public void configure(Binder binder) {
        binder.bind(LogInitTrigger.class).asEagerSingleton();
    }

    @Singleton
    @Provides
    Logger provideRootLogger(ConfigurationFactory configFactory, ShutdownManager shutdownManager, @LogLevels Map<String, Level> defaultLevels) {
        return ((LogbackContextFactory)this.config(LogbackContextFactory.class, configFactory)).createRootLogger(shutdownManager, defaultLevels);
    }

    static class LogInitTrigger {
        @Inject
        public LogInitTrigger(Logger rootLogger) {
            rootLogger.debug("Logback started");
        }
    }
}

