/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeFormDefinition;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ZeebeFormDefinitionValidator
implements ModelElementValidator<ZeebeFormDefinition> {
    private static final String ERROR_MESSAGE_ONE_NONEMPTY_ELEMENT = "Exactly one of the attributes '%s, %s' must be present and not blank%s";

    public Class<ZeebeFormDefinition> getElementType() {
        return ZeebeFormDefinition.class;
    }

    public void validate(ZeebeFormDefinition element, ValidationResultCollector validationResultCollector) {
        String formKey = element.getFormKey();
        String formId = element.getFormId();
        String externalReference = element.getExternalReference();
        ModelElementInstance nativeUserTaskElement = element.getParentElement().getUniqueChildElementByNameNs("http://camunda.org/schema/zeebe/1.0", "userTask");
        if (nativeUserTaskElement == null) {
            if (this.isBlank(formKey) == this.isBlank(formId)) {
                validationResultCollector.addError(0, String.format(ERROR_MESSAGE_ONE_NONEMPTY_ELEMENT, "formId", "formKey", ""));
            }
        } else if (this.isBlank(externalReference) == this.isBlank(formId)) {
            validationResultCollector.addError(0, String.format(ERROR_MESSAGE_ONE_NONEMPTY_ELEMENT, "formId", "externalReference", " for native user tasks"));
        }
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }
}

