/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.CompleteJobCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.CompleteJobResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.CommandWithVariables;
import io.camunda.zeebe.client.impl.response.CompleteJobResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class CompleteJobCommandImpl
extends CommandWithVariables<CompleteJobCommandStep1>
implements CompleteJobCommandStep1 {
    private final GatewayGrpc.GatewayStub asyncStub;
    private final GatewayOuterClass.CompleteJobRequest.Builder builder;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public CompleteJobCommandImpl(GatewayGrpc.GatewayStub asyncStub, JsonMapper jsonMapper, long key, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        super(jsonMapper);
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.builder = GatewayOuterClass.CompleteJobRequest.newBuilder();
        this.builder.setJobKey(key);
    }

    @Override
    public FinalCommandStep<CompleteJobResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<CompleteJobResponse> send() {
        GatewayOuterClass.CompleteJobRequest request = this.builder.build();
        RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse> future = new RetriableClientFutureImpl<CompleteJobResponse, GatewayOuterClass.CompleteJobResponse>(CompleteJobResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)streamObserver));
        this.send(request, (StreamObserver<GatewayOuterClass.CompleteJobResponse>)future);
        return future;
    }

    private void send(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).completeJob(request, streamObserver);
    }

    @Override
    protected CompleteJobCommandStep1 setVariablesInternal(String variables) {
        this.builder.setVariables(variables);
        return this;
    }
}

