/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.worker;

import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.impl.Loggers;
import io.camunda.zeebe.client.impl.worker.JobPoller;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.slf4j.Logger;

public final class JobPollerImpl
implements JobPoller {
    private static final Logger LOG = Loggers.JOB_POLLER_LOGGER;
    private final JobClient jobClient;
    private final Duration requestTimeout;
    private final String jobType;
    private final String workerName;
    private final Duration timeout;
    private final List<String> fetchVariables;
    private final List<String> tenantIds;
    private int maxJobsToActivate;
    private Consumer<ActivatedJob> jobConsumer;
    private IntConsumer doneCallback;
    private Consumer<Throwable> errorCallback;
    private int activatedJobs;
    private BooleanSupplier openSupplier;

    public JobPollerImpl(JobClient jobClient, Duration requestTimeout, String jobType, String workerName, Duration timeout, List<String> fetchVariables, List<String> tenantIds, int maxJobsToActivate) {
        this.requestTimeout = requestTimeout;
        this.jobClient = jobClient;
        this.jobType = jobType;
        this.workerName = workerName;
        this.timeout = timeout;
        this.fetchVariables = fetchVariables;
        this.tenantIds = tenantIds;
        this.maxJobsToActivate = maxJobsToActivate;
    }

    private void reset() {
        this.activatedJobs = 0;
    }

    @Override
    public void poll(int maxJobsToActivate, Consumer<ActivatedJob> jobConsumer, IntConsumer doneCallback, Consumer<Throwable> errorCallback, BooleanSupplier openSupplier) {
        this.reset();
        this.maxJobsToActivate = maxJobsToActivate;
        this.jobConsumer = jobConsumer;
        this.doneCallback = doneCallback;
        this.errorCallback = errorCallback;
        this.openSupplier = openSupplier;
        this.poll();
    }

    private void poll() {
        LOG.trace("Polling at max {} jobs for worker {} and job type {}", new Object[]{this.maxJobsToActivate, this.workerName, this.jobType});
        ActivateJobsCommandStep1.ActivateJobsCommandStep3 activateCommand = (ActivateJobsCommandStep1.ActivateJobsCommandStep3)this.jobClient.newActivateJobsCommand().jobType(this.jobType).maxJobsToActivate(this.maxJobsToActivate).timeout(this.timeout).workerName(this.workerName).tenantIds(this.tenantIds);
        if (this.fetchVariables != null) {
            activateCommand.fetchVariables(this.fetchVariables);
        }
        activateCommand.requestTimeout(this.requestTimeout).send().exceptionally(throwable -> {
            if (this.openSupplier.getAsBoolean()) {
                try {
                    this.logFailure((Throwable)throwable);
                }
                finally {
                    this.errorCallback.accept((Throwable)throwable);
                }
            }
            return null;
        }).thenApply(activateJobsResponse -> {
            List<ActivatedJob> jobs = activateJobsResponse.getJobs();
            this.activatedJobs += jobs.size();
            jobs.forEach(this.jobConsumer);
            if (this.activatedJobs > 0) {
                LOG.debug("Activated {} jobs for worker {} and job type {}", new Object[]{this.activatedJobs, this.workerName, this.jobType});
            } else {
                LOG.trace("No jobs activated for worker {} and job type {}", (Object)this.workerName, (Object)this.jobType);
            }
            this.doneCallback.accept(this.activatedJobs);
            return null;
        });
    }

    private void logFailure(Throwable throwable) {
        StatusRuntimeException statusRuntimeException;
        String errorMsg = "Failed to activate jobs for worker {} and job type {}";
        if (throwable instanceof StatusRuntimeException && (statusRuntimeException = (StatusRuntimeException)throwable).getStatus().getCode() == Status.RESOURCE_EXHAUSTED.getCode()) {
            LOG.trace("Failed to activate jobs for worker {} and job type {}", new Object[]{this.workerName, this.jobType, throwable});
            return;
        }
        LOG.warn("Failed to activate jobs for worker {} and job type {}", new Object[]{this.workerName, this.jobType, throwable});
    }
}

