/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.impl.http.ApiEntity;
import io.camunda.zeebe.client.impl.http.TypedApiEntityConsumer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.nio.entity.AbstractBinAsyncEntityConsumer;

final class ApiEntityConsumer<T>
extends AbstractBinAsyncEntityConsumer<ApiEntity<T>> {
    private static final List<ContentType> SUPPORTED_TEXT_CONTENT_TYPES = Arrays.asList(ContentType.TEXT_XML);
    private final ObjectMapper json;
    private final Class<T> type;
    private final int maxCapacity;
    private TypedApiEntityConsumer<T> entityConsumer;

    ApiEntityConsumer(ObjectMapper json, Class<T> type, int maxCapacity) {
        this.json = json;
        this.type = type;
        this.maxCapacity = maxCapacity;
    }

    protected void streamStart(ContentType contentType) throws IOException {
        if (ContentType.APPLICATION_JSON.isSameMimeType(contentType)) {
            this.entityConsumer = new TypedApiEntityConsumer.JsonApiEntityConsumer<T>(this.json, this.type, true);
        } else if (ContentType.APPLICATION_PROBLEM_JSON.isSameMimeType(contentType)) {
            this.entityConsumer = new TypedApiEntityConsumer.JsonApiEntityConsumer<T>(this.json, this.type, false);
        } else {
            boolean isResponse = String.class.equals(this.type) && SUPPORTED_TEXT_CONTENT_TYPES.stream().anyMatch(t -> t.isSameMimeType(contentType));
            this.entityConsumer = new TypedApiEntityConsumer.RawApiEntityConsumer(isResponse);
        }
    }

    protected ApiEntity<T> generateContent() throws IOException {
        return this.entityConsumer.generateContent();
    }

    protected int capacityIncrement() {
        return this.maxCapacity - this.entityConsumer.getBufferedBytes();
    }

    protected void data(ByteBuffer src, boolean endOfStream) throws IOException {
        this.entityConsumer.consumeData(src, endOfStream);
    }

    public void releaseResources() {
        if (this.entityConsumer != null) {
            this.entityConsumer.releaseResources();
        }
    }
}

