/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.FlownodeInstanceFilter;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.query.FlownodeInstanceQuery;
import io.camunda.zeebe.client.api.search.response.FlowNodeInstance;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.sort.FlownodeInstanceSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchRequestPageImpl;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.impl.search.sort.FlownodeInstanceSortImpl;
import io.camunda.zeebe.client.protocol.rest.FlowNodeInstanceFilterRequest;
import io.camunda.zeebe.client.protocol.rest.FlowNodeInstanceSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.FlowNodeInstanceSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.SearchQuerySortRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class FlowNodeInstanceQueryImpl
extends TypedSearchRequestPropertyProvider<FlowNodeInstanceSearchQueryRequest>
implements FlownodeInstanceQuery {
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final FlowNodeInstanceSearchQueryRequest request = new FlowNodeInstanceSearchQueryRequest();
    private final RequestConfig.Builder httpRequestConfig;

    public FlowNodeInstanceQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<FlowNodeInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SearchQueryResponse<FlowNodeInstance>> send() {
        HttpZeebeFuture<SearchQueryResponse<FlowNodeInstance>> result = new HttpZeebeFuture<SearchQueryResponse<FlowNodeInstance>>();
        this.httpClient.post("/flownode-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), FlowNodeInstanceSearchQueryResponse.class, SearchResponseMapper::toFlowNodeInstanceSearchResponse, result);
        return result;
    }

    @Override
    public FlownodeInstanceQuery filter(FlownodeInstanceFilter value) {
        FlowNodeInstanceFilterRequest filter = (FlowNodeInstanceFilterRequest)FlowNodeInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public FlownodeInstanceQuery filter(Consumer<FlownodeInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.flowNodeInstanceFilter(fn));
    }

    @Override
    public FlownodeInstanceQuery sort(FlownodeInstanceSort value) {
        FlownodeInstanceSortImpl sorting = (FlownodeInstanceSortImpl)value;
        this.request.setSort((List<SearchQuerySortRequest>)sorting.getSearchRequestProperty());
        return this;
    }

    @Override
    public FlownodeInstanceQuery sort(Consumer<FlownodeInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.flowNodeInstanceSort(fn));
    }

    @Override
    public FlownodeInstanceQuery page(SearchRequestPage value) {
        SearchRequestPageImpl page = (SearchRequestPageImpl)value;
        this.request.setPage(page.getSearchRequestProperty());
        return this;
    }

    @Override
    public FlownodeInstanceQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected FlowNodeInstanceSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

