/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.camunda.zeebe.client.protocol.rest.EvaluatedDecisionOutputItem;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"ruleId", "ruleIndex", "evaluatedOutputs"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MatchedDecisionRuleItem {
    public static final String JSON_PROPERTY_RULE_ID = "ruleId";
    private String ruleId;
    public static final String JSON_PROPERTY_RULE_INDEX = "ruleIndex";
    private Integer ruleIndex;
    public static final String JSON_PROPERTY_EVALUATED_OUTPUTS = "evaluatedOutputs";
    private List<EvaluatedDecisionOutputItem> evaluatedOutputs = new ArrayList<EvaluatedDecisionOutputItem>();

    public MatchedDecisionRuleItem ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Nullable
    @JsonProperty(value="ruleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="ruleId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public MatchedDecisionRuleItem ruleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
        return this;
    }

    @Nullable
    @JsonProperty(value="ruleIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRuleIndex() {
        return this.ruleIndex;
    }

    @JsonProperty(value="ruleIndex")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRuleIndex(Integer ruleIndex) {
        this.ruleIndex = ruleIndex;
    }

    public MatchedDecisionRuleItem evaluatedOutputs(List<EvaluatedDecisionOutputItem> evaluatedOutputs) {
        this.evaluatedOutputs = evaluatedOutputs;
        return this;
    }

    public MatchedDecisionRuleItem addEvaluatedOutputsItem(EvaluatedDecisionOutputItem evaluatedOutputsItem) {
        if (this.evaluatedOutputs == null) {
            this.evaluatedOutputs = new ArrayList<EvaluatedDecisionOutputItem>();
        }
        this.evaluatedOutputs.add(evaluatedOutputsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="evaluatedOutputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EvaluatedDecisionOutputItem> getEvaluatedOutputs() {
        return this.evaluatedOutputs;
    }

    @JsonProperty(value="evaluatedOutputs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvaluatedOutputs(List<EvaluatedDecisionOutputItem> evaluatedOutputs) {
        this.evaluatedOutputs = evaluatedOutputs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchedDecisionRuleItem matchedDecisionRuleItem = (MatchedDecisionRuleItem)o;
        return Objects.equals(this.ruleId, matchedDecisionRuleItem.ruleId) && Objects.equals(this.ruleIndex, matchedDecisionRuleItem.ruleIndex) && Objects.equals(this.evaluatedOutputs, matchedDecisionRuleItem.evaluatedOutputs);
    }

    public int hashCode() {
        return Objects.hash(this.ruleId, this.ruleIndex, this.evaluatedOutputs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MatchedDecisionRuleItem {\n");
        sb.append("    ruleId: ").append(this.toIndentedString(this.ruleId)).append("\n");
        sb.append("    ruleIndex: ").append(this.toIndentedString(this.ruleIndex)).append("\n");
        sb.append("    evaluatedOutputs: ").append(this.toIndentedString(this.evaluatedOutputs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRuleId() != null) {
            try {
                joiner.add(String.format("%sruleId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRuleId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getRuleIndex() != null) {
            try {
                joiner.add(String.format("%sruleIndex%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRuleIndex()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getEvaluatedOutputs() != null) {
            for (int i = 0; i < this.getEvaluatedOutputs().size(); ++i) {
                if (this.getEvaluatedOutputs().get(i) == null) continue;
                joiner.add(this.getEvaluatedOutputs().get(i).toUrlQueryString(String.format("%sevaluatedOutputs%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

