/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "batchOperationId", "type", "state", "errorMessage", "completedDate"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OperationItem {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_BATCH_OPERATION_ID = "batchOperationId";
    private String batchOperationId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private String errorMessage;
    public static final String JSON_PROPERTY_COMPLETED_DATE = "completedDate";
    private String completedDate;

    public OperationItem id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public OperationItem batchOperationId(String batchOperationId) {
        this.batchOperationId = batchOperationId;
        return this;
    }

    @Nullable
    @JsonProperty(value="batchOperationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBatchOperationId() {
        return this.batchOperationId;
    }

    @JsonProperty(value="batchOperationId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBatchOperationId(String batchOperationId) {
        this.batchOperationId = batchOperationId;
    }

    public OperationItem type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OperationItem state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public OperationItem errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public OperationItem completedDate(String completedDate) {
        this.completedDate = completedDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="completedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCompletedDate() {
        return this.completedDate;
    }

    @JsonProperty(value="completedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompletedDate(String completedDate) {
        this.completedDate = completedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationItem operationItem = (OperationItem)o;
        return Objects.equals(this.id, operationItem.id) && Objects.equals(this.batchOperationId, operationItem.batchOperationId) && Objects.equals((Object)this.type, (Object)operationItem.type) && Objects.equals((Object)this.state, (Object)operationItem.state) && Objects.equals(this.errorMessage, operationItem.errorMessage) && Objects.equals(this.completedDate, operationItem.completedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.batchOperationId, this.type, this.state, this.errorMessage, this.completedDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    batchOperationId: ").append(this.toIndentedString(this.batchOperationId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    completedDate: ").append(this.toIndentedString(this.completedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getId() != null) {
            try {
                joiner.add(String.format("%sid%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getBatchOperationId() != null) {
            try {
                joiner.add(String.format("%sbatchOperationId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getBatchOperationId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getType() != null) {
            try {
                joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getType()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getState() != null) {
            try {
                joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf((Object)this.getState()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getErrorMessage() != null) {
            try {
                joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCompletedDate() != null) {
            try {
                joiner.add(String.format("%scompletedDate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getCompletedDate()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }

    public static enum TypeEnum {
        RESOLVE_INCIDENT("RESOLVE_INCIDENT"),
        CANCEL_PROCESS_INSTANCE("CANCEL_PROCESS_INSTANCE"),
        DELETE_PROCESS_INSTANCE("DELETE_PROCESS_INSTANCE"),
        ADD_VARIABLE("ADD_VARIABLE"),
        UPDATE_VARIABLE("UPDATE_VARIABLE"),
        MODIFY_PROCESS_INSTANCE("MODIFY_PROCESS_INSTANCE"),
        DELETE_DECISION_DEFINITION("DELETE_DECISION_DEFINITION"),
        DELETE_PROCESS_DEFINITION("DELETE_PROCESS_DEFINITION"),
        MIGRATE_PROCESS_INSTANCE("MIGRATE_PROCESS_INSTANCE"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum StateEnum {
        SCHEDULED("SCHEDULED"),
        LOCKED("LOCKED"),
        SENT("SENT"),
        FAILED("FAILED"),
        COMPLETED("COMPLETED"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

