/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.http;

import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.ProblemException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpZeebeFuture<RespT>
extends CompletableFuture<RespT>
implements ZeebeFuture<RespT> {
    private volatile Future<?> transportFuture;

    @Override
    public RespT join() {
        try {
            return (RespT)this.get();
        }
        catch (ExecutionException e) {
            throw this.unwrapExecutionException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClientException("Failed: interrupted while awaiting response", e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.transportFuture != null) {
            this.transportFuture.cancel(mayInterruptIfRunning);
        }
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public RespT join(long timeout, TimeUnit unit) {
        try {
            return (RespT)super.get(timeout, unit);
        }
        catch (ExecutionException e) {
            throw this.unwrapExecutionException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ClientException("Failed: interrupted while awaiting response", e);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed: timed out waiting on client response", e);
        }
    }

    public void transportFuture(Future<?> httpFuture) {
        this.transportFuture = httpFuture;
        if (this.isCancelled()) {
            httpFuture.cancel(true);
        }
    }

    private ProblemException unwrapExecutionException(ExecutionException e) {
        Throwable cause = e.getCause();
        if (cause instanceof ProblemException) {
            throw (ProblemException)cause;
        }
        throw new ClientException(cause);
    }
}

