/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.protocol.rest.ActivatedJob;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class ActivatedJobImpl
implements io.camunda.zeebe.client.api.response.ActivatedJob {
    @JsonIgnore
    private final JsonMapper jsonMapper;
    private final long key;
    private final String type;
    private final Map<String, String> customHeaders;
    private final long processInstanceKey;
    private final String bpmnProcessId;
    private final int processDefinitionVersion;
    private final long processDefinitionKey;
    private final String elementId;
    private final long elementInstanceKey;
    private final String tenantId;
    private final String worker;
    private final int retries;
    private final long deadline;
    private final String variables;
    private Map<String, Object> variablesAsMap;

    public ActivatedJobImpl(JsonMapper jsonMapper, GatewayOuterClass.ActivatedJob job) {
        this.jsonMapper = jsonMapper;
        this.key = job.getKey();
        this.type = job.getType();
        String customHeaders = job.getCustomHeaders();
        this.customHeaders = customHeaders.isEmpty() ? new HashMap() : jsonMapper.fromJsonAsStringMap(customHeaders);
        this.worker = job.getWorker();
        this.retries = job.getRetries();
        this.deadline = job.getDeadline();
        this.variables = job.getVariables();
        this.processInstanceKey = job.getProcessInstanceKey();
        this.bpmnProcessId = job.getBpmnProcessId();
        this.processDefinitionVersion = job.getProcessDefinitionVersion();
        this.processDefinitionKey = job.getProcessDefinitionKey();
        this.elementId = job.getElementId();
        this.elementInstanceKey = job.getElementInstanceKey();
        this.tenantId = job.getTenantId();
    }

    public ActivatedJobImpl(JsonMapper jsonMapper, ActivatedJob job) {
        this.jsonMapper = jsonMapper;
        this.key = ActivatedJobImpl.getOrEmpty(job.getJobKey());
        this.type = ActivatedJobImpl.getOrEmpty(job.getType());
        this.customHeaders = job.getCustomHeaders() == null ? new HashMap<String, String>() : job.getCustomHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue() instanceof String ? (String)e.getValue() : jsonMapper.toJson(e.getValue())));
        this.worker = ActivatedJobImpl.getOrEmpty(job.getWorker());
        this.retries = ActivatedJobImpl.getOrEmpty(job.getRetries());
        this.deadline = ActivatedJobImpl.getOrEmpty(job.getDeadline());
        this.variablesAsMap = job.getVariables() == null ? new HashMap() : job.getVariables();
        this.variables = jsonMapper.toJson(this.variablesAsMap);
        this.processInstanceKey = ActivatedJobImpl.getOrEmpty(job.getProcessInstanceKey());
        this.bpmnProcessId = ActivatedJobImpl.getOrEmpty(job.getProcessDefinitionId());
        this.processDefinitionVersion = ActivatedJobImpl.getOrEmpty(job.getProcessDefinitionVersion());
        this.processDefinitionKey = ActivatedJobImpl.getOrEmpty(job.getProcessDefinitionKey());
        this.elementId = ActivatedJobImpl.getOrEmpty(job.getElementId());
        this.elementInstanceKey = ActivatedJobImpl.getOrEmpty(job.getElementInstanceKey());
        this.tenantId = ActivatedJobImpl.getOrEmpty(job.getTenantId());
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    @Override
    public String getWorker() {
        return this.worker;
    }

    @Override
    public int getRetries() {
        return this.retries;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public String getVariables() {
        return this.variables;
    }

    @Override
    public Map<String, Object> getVariablesAsMap() {
        if (this.variablesAsMap == null) {
            this.variablesAsMap = this.jsonMapper.fromJsonAsMap(this.variables);
        }
        return this.variablesAsMap;
    }

    @Override
    public <T> T getVariablesAsType(Class<T> variableType) {
        return this.jsonMapper.fromJson(this.variables, variableType);
    }

    @Override
    public Object getVariable(String name) {
        Map<String, Object> variables = this.getVariablesAsMap();
        if (!variables.containsKey(name)) {
            throw new ClientException(String.format("The variable %s is not available", name));
        }
        return this.getVariablesAsMap().get(name);
    }

    @Override
    public String toJson() {
        return this.jsonMapper.toJson(this);
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public String toString() {
        return this.toJson();
    }

    private static String getOrEmpty(String value) {
        return value == null ? "" : value;
    }

    private static Long getOrEmpty(Long value) {
        return value == null ? -1L : value;
    }

    private static Integer getOrEmpty(Integer value) {
        return value == null ? -1 : value;
    }
}

