/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search.query;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.search.SearchRequestBuilders;
import io.camunda.zeebe.client.api.search.SearchRequestPage;
import io.camunda.zeebe.client.api.search.filter.ProcessInstanceFilter;
import io.camunda.zeebe.client.api.search.query.FinalSearchQueryStep;
import io.camunda.zeebe.client.api.search.query.ProcessInstanceQuery;
import io.camunda.zeebe.client.api.search.response.ProcessInstance;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.sort.ProcessInstanceSort;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import io.camunda.zeebe.client.impl.search.SearchResponseMapper;
import io.camunda.zeebe.client.impl.search.TypedSearchRequestPropertyProvider;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceFilterRequest;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceSearchQueryRequest;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ProcessInstanceQueryImpl
extends TypedSearchRequestPropertyProvider<ProcessInstanceSearchQueryRequest>
implements ProcessInstanceQuery {
    private final ProcessInstanceSearchQueryRequest request = new ProcessInstanceSearchQueryRequest();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public ProcessInstanceQueryImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public FinalSearchQueryStep<ProcessInstance> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<SearchQueryResponse<ProcessInstance>> send() {
        HttpZeebeFuture<SearchQueryResponse<ProcessInstance>> result = new HttpZeebeFuture<SearchQueryResponse<ProcessInstance>>();
        this.httpClient.post("/process-instances/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), ProcessInstanceSearchQueryResponse.class, SearchResponseMapper::toProcessInstanceSearchResponse, result);
        return result;
    }

    @Override
    public ProcessInstanceQuery filter(ProcessInstanceFilter value) {
        ProcessInstanceFilterRequest filter = (ProcessInstanceFilterRequest)ProcessInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setFilter(filter);
        return this;
    }

    @Override
    public ProcessInstanceQuery filter(Consumer<ProcessInstanceFilter> fn) {
        return this.filter(SearchRequestBuilders.processInstanceFilter(fn));
    }

    @Override
    public ProcessInstanceQuery sort(ProcessInstanceSort value) {
        List sorting = (List)ProcessInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setSort(sorting);
        return this;
    }

    @Override
    public ProcessInstanceQuery sort(Consumer<ProcessInstanceSort> fn) {
        return this.sort(SearchRequestBuilders.processInstanceSort(fn));
    }

    @Override
    public ProcessInstanceQuery page(SearchRequestPage value) {
        SearchQueryPageRequest page = (SearchQueryPageRequest)ProcessInstanceQueryImpl.provideSearchRequestProperty(value);
        this.request.setPage(page);
        return this;
    }

    @Override
    public ProcessInstanceQuery page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected ProcessInstanceSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

