/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.DeleteDocumentCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DeleteDocumentResponse;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.http.HttpClient;
import io.camunda.zeebe.client.impl.http.HttpZeebeFuture;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class DeleteDocumentCommandImpl
implements DeleteDocumentCommandStep1 {
    private final HttpClient client;
    private final String documentId;
    private final RequestConfig.Builder requestConfig;
    private String storeId;

    public DeleteDocumentCommandImpl(String documentId, String storeId, HttpClient client, ZeebeClientConfiguration configuration) {
        ArgumentUtil.ensureNotNull("documentId", documentId);
        this.documentId = documentId;
        this.client = client;
        this.storeId = storeId;
        this.requestConfig = client.newRequestConfig();
        this.requestTimeout(configuration.getDefaultRequestTimeout());
    }

    @Override
    public DeleteDocumentCommandStep1 storeId(String storeId) {
        this.storeId = storeId;
        return this;
    }

    @Override
    public FinalCommandStep<DeleteDocumentResponse> requestTimeout(Duration requestTimeout) {
        this.requestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public ZeebeFuture<DeleteDocumentResponse> send() {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.storeId != null) {
            queryParams.put("storeId", this.storeId);
        }
        HttpZeebeFuture<DeleteDocumentResponse> result = new HttpZeebeFuture<DeleteDocumentResponse>();
        this.client.delete(String.format("/documents/%s", this.documentId), queryParams, this.requestConfig.build(), result);
        return result;
    }
}

