/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"signalName", "variables", "tenantId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SignalBroadcastRequest {
    public static final String JSON_PROPERTY_SIGNAL_NAME = "signalName";
    private String signalName;
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private Map<String, Object> variables = new HashMap<String, Object>();
    public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
    private String tenantId;

    public SignalBroadcastRequest signalName(String signalName) {
        this.signalName = signalName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="signalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSignalName() {
        return this.signalName;
    }

    @JsonProperty(value="signalName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public SignalBroadcastRequest variables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public SignalBroadcastRequest putVariablesItem(String key, Object variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public SignalBroadcastRequest tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    @JsonProperty(value="tenantId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalBroadcastRequest signalBroadcastRequest = (SignalBroadcastRequest)o;
        return Objects.equals(this.signalName, signalBroadcastRequest.signalName) && Objects.equals(this.variables, signalBroadcastRequest.variables) && Objects.equals(this.tenantId, signalBroadcastRequest.tenantId);
    }

    public int hashCode() {
        return Objects.hash(this.signalName, this.variables, this.tenantId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignalBroadcastRequest {\n");
        sb.append("    signalName: ").append(this.toIndentedString(this.signalName)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSignalName() != null) {
            try {
                joiner.add(String.format("%ssignalName%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSignalName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                try {
                    joiner.add(String.format("%svariables%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getVariables().get(_key), URLEncoder.encode(String.valueOf(this.getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.getTenantId() != null) {
            try {
                joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

