/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.protocol.rest;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"roleId", "name", "description"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RoleCreateRequest {
    public static final String JSON_PROPERTY_ROLE_ID = "roleId";
    @Nonnull
    private String roleId;
    public static final String JSON_PROPERTY_NAME = "name";
    @Nonnull
    private String name;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    @Nullable
    private String description;

    public RoleCreateRequest roleId(@Nonnull String roleId) {
        this.roleId = roleId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="roleId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoleId() {
        return this.roleId;
    }

    @JsonProperty(value="roleId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoleId(@Nonnull String roleId) {
        this.roleId = roleId;
    }

    public RoleCreateRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public RoleCreateRequest description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleCreateRequest roleCreateRequest = (RoleCreateRequest)o;
        return Objects.equals(this.roleId, roleCreateRequest.roleId) && Objects.equals(this.name, roleCreateRequest.name) && Objects.equals(this.description, roleCreateRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.roleId, this.name, this.description);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleCreateRequest {\n");
        sb.append("    roleId: ").append(this.toIndentedString(this.roleId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRoleId() != null) {
            try {
                joiner.add(String.format("%sroleId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getRoleId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getName() != null) {
            try {
                joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getName()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getDescription() != null) {
            try {
                joiner.add(String.format("%sdescription%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getDescription()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return joiner.toString();
    }
}

