/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.util;

import io.camunda.zeebe.client.api.command.ClientException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ExecutorResource
implements AutoCloseable {
    private final ScheduledExecutorService executor;
    private final boolean ownsResource;

    public ExecutorResource(ScheduledExecutorService executor, boolean ownsResource) {
        this.executor = executor;
        this.ownsResource = ownsResource;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    @Override
    public void close() {
        if (!this.ownsResource) {
            return;
        }
        this.executor.shutdownNow();
        try {
            if (!this.executor.awaitTermination(15L, TimeUnit.SECONDS)) {
                throw new ClientException("Timed out awaiting termination of job worker executor after 15 seconds");
            }
        }
        catch (InterruptedException e) {
            throw new ClientException("Unexpected interrupted awaiting termination of job worker executor", e);
        }
    }
}

