/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.store.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.auth.store.data.AuthEntryType;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.trustservice.store.data.IdentityPool;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class IdentityPoolValue
extends AuthValue {
    private final long version;
    private final String providerId;
    private final String issuer;
    private final String subjectClaim;
    private final String serviceAccount;
    private final String policy;
    private final String orgId;

    @JsonCreator
    public IdentityPoolValue(@JsonProperty(value="version") long version, @JsonProperty(value="providerId") String providerId, @JsonProperty(value="issuer") String issuer, @JsonProperty(value="subjectClaim") String subjectClaim, @JsonProperty(value="principalClaim") String principalClaim, @JsonProperty(value="serviceAccount") String serviceAccount, @JsonProperty(value="policy") String policy, @JsonProperty(value="filter") String filter, @JsonProperty(value="orgId") String orgId) {
        this.version = version;
        this.providerId = providerId;
        this.issuer = Objects.requireNonNull(issuer, "Argument `issuer` must not be null");
        this.subjectClaim = principalClaim != null ? principalClaim : (subjectClaim == null ? "sub" : subjectClaim);
        this.serviceAccount = Objects.requireNonNull(serviceAccount, "Argument `serviceAccount` must not be null");
        this.policy = filter != null ? filter : Objects.requireNonNull(policy, "Argument `policy` must not be null");
        this.orgId = orgId == null ? "" : orgId;
    }

    public IdentityPoolValue(long version, String issuer, String subjectClaim, String serviceAccount, String policy, String orgId) {
        this(version, null, issuer, subjectClaim, null, serviceAccount, policy, null, orgId);
    }

    public IdentityPoolValue(long version, String issuer, String subjectClaim, String serviceAccount, String policy) {
        this(version, null, issuer, subjectClaim, null, serviceAccount, policy, null, null);
    }

    public IdentityPoolValue(long version, String issuer, String subjectClaim, String principalClaim, String serviceAccount, String policy, String filter) {
        this(version, null, issuer, subjectClaim, principalClaim, serviceAccount, policy, filter, null);
    }

    public IdentityPoolValue(IdentityPool identityPool) {
        this(identityPool.version(), identityPool.issuer(), identityPool.subjectClaim(), identityPool.serviceAccount(), identityPool.policy().condition(), identityPool.orgId());
    }

    @JsonProperty(value="version")
    public long version() {
        return this.version;
    }

    @JsonProperty(value="providerId")
    public String providerId() {
        return this.providerId;
    }

    @JsonProperty(value="issuer")
    public String issuer() {
        return this.issuer;
    }

    @JsonProperty(value="subjectClaim")
    public String subjectClaim() {
        return this.subjectClaim;
    }

    @JsonProperty(value="serviceAccount")
    public String serviceAccount() {
        return this.serviceAccount;
    }

    @JsonProperty(value="policy")
    public String policy() {
        return this.policy;
    }

    @JsonProperty(value="orgId")
    public String orgId() {
        return this.orgId;
    }

    @Override
    @JsonIgnore
    public AuthEntryType entryType() {
        return AuthEntryType.IDENTITY_POOL;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hash(this.version, this.providerId, this.issuer, this.subjectClaim, this.serviceAccount, this.policy, this.orgId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentityPoolValue)) {
            return false;
        }
        IdentityPoolValue that = (IdentityPoolValue)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.issuer, that.issuer) && Objects.equals(this.providerId, that.providerId) && Objects.equals(this.subjectClaim, that.subjectClaim) && Objects.equals(this.serviceAccount, that.serviceAccount) && Objects.equals(this.policy, that.policy) && Objects.equals(this.orgId, that.orgId);
    }

    public String toString() {
        return String.format("IdentityPoolValue{\n\tversion=%s\n\tproviderId=%s\n\tissuer=%s\n\tsubjectClaim=%s\n\tserviceAccount=%s\n\tpolicy=%s\n\torgId=%s\n}", this.version, this.providerId, this.issuer, this.subjectClaim, this.serviceAccount, this.policy, this.orgId);
    }
}

