/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common;

import java.util.Map;
import org.apache.kafka.common.config.ConfigException;

public class InterClusterConnection {
    private static final String ADVERTISED_LISTENERS_CONFIG = "advertised.listeners";
    private static final String LISTENER_SECURITY_PROTOCOL = "listener.security.protocol.map";

    public static String getBootstrapBrokerForListener(String listener, Map<String, ?> cfgMap) throws ConfigException {
        String bootstrapBroker = null;
        if (cfgMap.get(ADVERTISED_LISTENERS_CONFIG) != null) {
            if (cfgMap.get(ADVERTISED_LISTENERS_CONFIG) instanceof String) {
                String[] listeners;
                int brokerStartIndex = listener.length() + 3;
                String advertisedListeners = (String)cfgMap.get(ADVERTISED_LISTENERS_CONFIG);
                for (String advertisedListener : listeners = advertisedListeners.split(",")) {
                    if (!advertisedListener.contains(listener) || advertisedListener.length() <= brokerStartIndex) continue;
                    bootstrapBroker = advertisedListener.substring(brokerStartIndex);
                    break;
                }
            }
            if (bootstrapBroker == null) {
                throw new ConfigException(String.format("Expected to find %s listener in %s config", listener, ADVERTISED_LISTENERS_CONFIG));
            }
        } else {
            throw new ConfigException(String.format("%s config is required to validate topic creation", ADVERTISED_LISTENERS_CONFIG));
        }
        return bootstrapBroker;
    }

    public static String getListenerSecurityProtocol(String listener, Map<String, ?> cfgMap) throws ConfigException {
        String protocol = null;
        if (cfgMap.get(LISTENER_SECURITY_PROTOCOL) != null && cfgMap.get(LISTENER_SECURITY_PROTOCOL) instanceof String) {
            String[] securityProtocolsList;
            int protocolStartIndex = listener.length() + 1;
            String listenerSecurityProtocols = (String)cfgMap.get(LISTENER_SECURITY_PROTOCOL);
            for (String securityProtocol : securityProtocolsList = listenerSecurityProtocols.split(",")) {
                if (!securityProtocol.contains(listener) || securityProtocol.length() <= protocolStartIndex) continue;
                protocol = securityProtocol.substring(protocolStartIndex);
                break;
            }
        }
        return protocol;
    }
}

