/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.audit.event;

import io.confluent.security.authorizer.Scope;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuthenticationEvent;

public class ConfluentAuthenticationEvent
implements AuthenticationEvent {
    private final AuthenticationEvent authenticationEvent;
    private final Scope scope;
    private Map<String, Object> data;

    public ConfluentAuthenticationEvent(AuthenticationEvent authenticationEvent, Scope scope) {
        this.authenticationEvent = authenticationEvent;
        this.scope = scope;
        this.data = Objects.requireNonNull(authenticationEvent.data());
    }

    public Optional<KafkaPrincipal> principal() {
        return this.authenticationEvent.principal();
    }

    public AuthenticationContext authenticationContext() {
        return this.authenticationEvent.authenticationContext();
    }

    public Optional<AuthenticationException> authenticationException() {
        return this.authenticationEvent.authenticationException();
    }

    public UUID uuid() {
        return this.authenticationEvent.uuid();
    }

    public Instant timestamp() {
        return this.authenticationEvent.timestamp();
    }

    public AuditEventType type() {
        return this.authenticationEvent.type();
    }

    public AuditEventStatus status() {
        return this.authenticationEvent.status();
    }

    public Map<String, Object> data() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfluentAuthenticationEvent that = (ConfluentAuthenticationEvent)o;
        return Objects.equals(this.authenticationEvent, that.authenticationEvent) && Objects.equals(this.getScope(), that.getScope());
    }

    public int hashCode() {
        return Objects.hash(this.authenticationEvent, this.getScope());
    }

    public String toString() {
        return "ConfluentAuthenticationEvent{authenticationEvent=" + this.authenticationEvent + ", scope=" + this.scope + '}';
    }
}

