/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;

public class AuthAttemptCache {
    static final long DEFAULT_CACHE_TTL_MS = 60000L;
    static final int DEFAULT_MAX_SIZE = 50000;
    static final int DEFAULT_MAX_ENTRIES_PER_CLEANUP = 10;
    private final long ttl;
    private final long cleanupPeriodNs;
    private final int maxSize;
    private final Time time;
    private final int maxEntriesPerCleanup;
    private final ImplicitLinkedHashCollection<AuthCachePair> collection;
    private long lastCleanupNs;

    public AuthAttemptCache(long ttlMs, int maxSize, Time time, int maxEntriesPerCleanup) {
        this.ttl = TimeUnit.NANOSECONDS.convert(ttlMs, TimeUnit.MILLISECONDS);
        this.cleanupPeriodNs = Math.max(1L, this.ttl / 4L);
        this.maxSize = maxSize;
        this.time = time;
        this.maxEntriesPerCleanup = maxEntriesPerCleanup;
        this.collection = new ImplicitLinkedHashCollection();
        this.lastCleanupNs = 0L;
    }

    public AuthAttemptCache() {
        this(60000L, 50000, Time.SYSTEM, 10);
    }

    public synchronized String get(String username, String password) {
        long now = this.time.nanoseconds();
        AuthCachePair example = new AuthCachePair(username, password, null, 0L);
        AuthCachePair pair = (AuthCachePair)this.collection.find((ImplicitLinkedHashCollection.Element)example);
        String hash = null;
        if (pair != null) {
            this.collection.moveToTail((ImplicitLinkedHashCollection.Element)pair);
            pair.insertionTimeNs = now;
            hash = pair.hash;
        }
        this.maybeRemoveOldElements(now);
        return hash;
    }

    public synchronized void put(String username, String password, String hash) {
        long now = this.time.nanoseconds();
        AuthCachePair pair = new AuthCachePair(username, password, hash, now);
        this.collection.remove((Object)pair);
        this.collection.add((ImplicitLinkedHashCollection.Element)pair);
        this.maybeRemoveOldElements(now, this.collection.size());
    }

    public synchronized void invalidate(String username, String password) {
        AuthCachePair example = new AuthCachePair(username, password, null, 0L);
        this.collection.remove((Object)example);
        this.maybeRemoveOldElements(this.time.nanoseconds());
    }

    private synchronized void maybeRemoveOldElements(long now, int size) {
        if (size > this.maxSize) {
            this.removeOldElements(now);
        } else {
            this.maybeRemoveOldElements(now);
        }
    }

    private synchronized void maybeRemoveOldElements(long now) {
        if (now - this.lastCleanupNs > this.cleanupPeriodNs) {
            this.removeOldElements(now);
        }
    }

    private synchronized void removeOldElements(long now) {
        Iterator iter = this.collection.iterator();
        int numEntries = 0;
        while (iter.hasNext()) {
            AuthCachePair pair = (AuthCachePair)iter.next();
            if (this.collection.size() < this.maxSize && now - pair.insertionTimeNs < this.ttl) break;
            iter.remove();
            if (++numEntries < this.maxEntriesPerCleanup) continue;
            return;
        }
        this.lastCleanupNs = now;
    }

    static class AuthCachePair
    implements ImplicitLinkedHashCollection.Element {
        private final String username;
        private final String password;
        private final String hash;
        private long insertionTimeNs;
        private int prev;
        private int next;

        AuthCachePair(String username, String password, String hash, long insertionTimeNs) {
            this.username = username;
            this.password = password;
            this.hash = hash;
            this.insertionTimeNs = insertionTimeNs;
            this.prev = -2;
            this.next = -2;
        }

        public int prev() {
            return this.prev;
        }

        public void setPrev(int prev) {
            this.prev = prev;
        }

        public int next() {
            return this.next;
        }

        public void setNext(int next) {
            this.next = next;
        }

        public int hashCode() {
            return 31 * this.username.hashCode() ^ this.password.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthCachePair)) {
                return false;
            }
            AuthCachePair other = (AuthCachePair)o;
            return this.username.equals(other.username) && this.password.equals(other.password);
        }
    }
}

