/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.multitenant.utils.AuthUtils;
import io.confluent.kafka.server.plugins.auth.BaseMultiTenantSaslSecretsStore;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.PlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.TopicBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdAuthenticator;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import io.confluent.kafka.traffic.TopicBasedTrafficNetworkIdRoutesStore;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutes;
import org.apache.kafka.server.traffic.TrafficNetworkIdRoutesStore;

public class TopicBasedPlainSaslAuthenticator
extends PlainSaslAuthenticator {
    private final BaseMultiTenantSaslSecretsStore secretsLoader;
    private final TrafficNetworkIdRoutesStore routesLoader;
    protected TrafficNetworkIdValidationMode networkIdValidationMode;
    private final CCloudTrafficType trafficType;

    public TopicBasedPlainSaslAuthenticator(Map<String, ?> props) {
        this(BaseMultiTenantSaslSecretsStore.getInstance((String)AuthUtils.getBrokerSessionUuid(props)), TopicBasedTrafficNetworkIdRoutesStore.getInstance(AuthUtils.getBrokerSessionUuid(props)), (CCloudTrafficType)props.get("__confluent_ccloud_traffic_type"));
    }

    public TopicBasedPlainSaslAuthenticator(BaseMultiTenantSaslSecretsStore secretsLoader, TrafficNetworkIdRoutesStore routesLoader, CCloudTrafficType trafficType) {
        super(SUCCESSFUL_AUTH_CACHE, FAILED_AUTH_CACHE);
        this.secretsLoader = secretsLoader;
        this.routesLoader = routesLoader;
        this.trafficType = trafficType;
    }

    @Override
    public void initialize(List<AppConfigurationEntry> jaasContextEntries) {
        this.mode = SniValidationMode.fromString(TopicBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, "sni_host_name_validation_mode", TopicBasedLoginModule.class.getName()));
        this.networkIdValidationMode = TrafficNetworkIdValidationMode.fromConfigs(this.trafficType, () -> TopicBasedPlainSaslAuthenticator.configEntryOption(jaasContextEntries, "traffic_network_id_validation_mode", TopicBasedLoginModule.class.getName()));
        this.log.debug("TopicBasedPlainSaslAuthenticator initialized with mode: {}, networkIdValidationMode:{}.", (Object)this.mode.getText(), (Object)this.networkIdValidationMode.name());
    }

    boolean verifyNetworkId(MultiTenantSaslConfigEntry userInfo, String username, Optional<String> networkId) {
        TrafficNetworkIdRoutes networkIdRoutes = this.loadNetworkIdRoutes();
        TrafficNetworkIdAuthenticator networkIdAuthenticator = new TrafficNetworkIdAuthenticator(networkIdRoutes, this.networkIdValidationMode, errorMessage -> this.throwAuthException(userInfo, username, errorMessage + " for user name: " + username));
        return networkIdAuthenticator.authenticate(networkId, userInfo.logicalClusterId);
    }

    @Override
    protected void pluginAuthenticate(MultiTenantSaslConfigEntry userInfo, String username, Optional<String> networkId) {
        this.verifyNetworkId(userInfo, username, networkId);
    }

    @Override
    protected MultiTenantSaslSecrets loadSecrets() {
        return this.secretsLoader.load();
    }

    private TrafficNetworkIdRoutes loadNetworkIdRoutes() {
        return this.routesLoader != null ? this.routesLoader.load() : null;
    }
}

