/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.ssl;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import kafka.server.ssl.CertificateId;
import kafka.server.ssl.CertificateIdsJsonConfig;
import kafka.utils.ConfluentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentTrustManager
extends X509ExtendedTrustManager {
    private static final Logger log = LoggerFactory.getLogger(ConfluentTrustManager.class);
    private static final int DNS = 2;
    private final X509ExtendedTrustManager defaultTrustManager;
    private final Map<String, ?> configs;
    private final Set<CertificateId> revokedCertificateIds;

    public ConfluentTrustManager(Map<String, ?> configs, X509ExtendedTrustManager defaultTrustManager) {
        this.defaultTrustManager = defaultTrustManager;
        this.configs = configs;
        this.revokedCertificateIds = this.revokedCertificateIds(configs);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        if (socket instanceof SSLSocket) {
            if (((SSLSocket)socket).getNeedClientAuth()) {
                this.verifyClientCerts(x509Certificates);
            }
        } else {
            this.verifyClientCerts(x509Certificates);
        }
        this.defaultTrustManager.checkClientTrusted(x509Certificates, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        this.verifyServerCerts(x509Certificates);
        this.defaultTrustManager.checkServerTrusted(x509Certificates, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        if (sslEngine.getNeedClientAuth()) {
            this.verifyClientCerts(x509Certificates);
        }
        this.defaultTrustManager.checkClientTrusted(x509Certificates, authType, sslEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        this.verifyServerCerts(x509Certificates);
        this.defaultTrustManager.checkServerTrusted(x509Certificates, authType, sslEngine);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.verifyClientCerts(x509Certificates);
        this.defaultTrustManager.checkClientTrusted(x509Certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.verifyServerCerts(x509Certificates);
        this.defaultTrustManager.checkServerTrusted(x509Certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }

    boolean verifyClientCerts(X509Certificate[] x509Certificates) throws CertificateException {
        return this.verifyCerts(x509Certificates, true);
    }

    boolean verifyServerCerts(X509Certificate[] x509Certificates) throws CertificateException {
        return this.verifyCerts(x509Certificates, false);
    }

    boolean isConfluentCert(X509Certificate cert) {
        List<String> subjectAlts = this.getSubjectAltNames(cert);
        if (!subjectAlts.isEmpty()) {
            log.trace("Verifying the cert subjectAlts:{}", subjectAlts);
            for (String altName : subjectAlts) {
                if (!this.isCCloudName(altName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCCloudName(String name) {
        return ConfluentUtils.hasCCloudHostPattern(this.configs, (String)name);
    }

    private boolean verifyCerts(X509Certificate[] x509Certificates, boolean isClientCert) throws CertificateException {
        for (X509Certificate cert : x509Certificates) {
            if (!this.isConfluentCert(cert) || this.isRevoked(cert)) continue;
            return true;
        }
        String errorMsg = MessageFormat.format("A trusted {0} certificate not found", isClientCert ? "client" : "server");
        log.trace("The certificate verification failed due to: {}", (Object)errorMsg);
        throw new CertificateException(errorMsg);
    }

    List<String> getSubjectAltNames(X509Certificate cert) {
        try {
            Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
            if (altNames == null) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (List<?> altName : altNames) {
                Object o;
                Integer type = altName.size() >= 2 ? (Integer)altName.get(0) : null;
                if (type == null || type != 2 || !((o = altName.get(1)) instanceof String)) continue;
                result.add((String)o);
            }
            return result;
        }
        catch (CertificateParsingException ce) {
            log.trace("Ignoring certificate parsing exception", (Throwable)ce);
            return Collections.emptyList();
        }
    }

    private boolean isRevoked(X509Certificate cert) {
        return this.revokedCertificateIds.contains(new CertificateId(cert));
    }

    Set<CertificateId> revokedCertificateIds(Map<String, ?> config) {
        try {
            String revokedIdsString = (String)config.get("confluent.security.revoked.certificate.ids");
            CertificateIdsJsonConfig[] revokedIds = CertificateIdsJsonConfig.fromJson((String)revokedIdsString);
            HashSet<CertificateId> revokedCertificateIds = new HashSet<CertificateId>();
            Arrays.stream(revokedIds).forEach(id -> id.serialNumbers().stream().forEach(serialNumber -> revokedCertificateIds.add(new CertificateId(id.issuer(), serialNumber))));
            return revokedCertificateIds;
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to parse revoked certificate ids", e);
        }
    }
}

