/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.metrics;

import io.confluent.common.metrics.CompoundStat;
import io.confluent.common.metrics.KafkaMetric;
import io.confluent.common.metrics.Measurable;
import io.confluent.common.metrics.MeasurableStat;
import io.confluent.common.metrics.MetricConfig;
import io.confluent.common.metrics.MetricName;
import io.confluent.common.metrics.Metrics;
import io.confluent.common.metrics.Quota;
import io.confluent.common.metrics.QuotaViolationException;
import io.confluent.common.metrics.Stat;
import io.confluent.common.utils.Time;
import io.confluent.common.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Sensor {
    private final Metrics registry;
    private final String name;
    private final Sensor[] parents;
    private final List<Stat> stats;
    private final List<KafkaMetric> metrics;
    private final MetricConfig config;
    private final Time time;

    Sensor(Metrics registry, String name, Sensor[] parents, MetricConfig config, Time time) {
        this.registry = registry;
        this.name = (String)Utils.notNull((Object)name);
        this.parents = parents == null ? new Sensor[]{} : parents;
        this.metrics = new ArrayList<KafkaMetric>();
        this.stats = new ArrayList<Stat>();
        this.config = config;
        this.time = time;
        this.checkForest(new HashSet<Sensor>());
    }

    private void checkForest(Set<Sensor> sensors) {
        if (!sensors.add(this)) {
            throw new IllegalArgumentException("Circular dependency in sensors: " + this.name() + " is its own parent.");
        }
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i].checkForest(sensors);
        }
    }

    public String name() {
        return this.name;
    }

    public void record() {
        this.record(1.0);
    }

    public void record(double value) {
        this.record(value, this.time.milliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(double value, long timeMs) {
        Sensor sensor = this;
        synchronized (sensor) {
            for (int i = 0; i < this.stats.size(); ++i) {
                this.stats.get(i).record(this.config, value, timeMs);
            }
            this.checkQuotas(timeMs);
        }
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i].record(value, timeMs);
        }
    }

    private void checkQuotas(long timeMs) {
        for (int i = 0; i < this.metrics.size(); ++i) {
            Quota quota;
            KafkaMetric metric = this.metrics.get(i);
            MetricConfig config = metric.config();
            if (config == null || (quota = config.quota()) == null || quota.acceptable(metric.value(timeMs))) continue;
            throw new QuotaViolationException(metric.metricName() + " is in violation of its quota of " + quota.bound());
        }
    }

    public void add(CompoundStat stat) {
        this.add(stat, null);
    }

    public synchronized void add(CompoundStat stat, MetricConfig config) {
        this.stats.add((Stat)Utils.notNull((Object)stat));
        for (CompoundStat.NamedMeasurable m : stat.stats()) {
            KafkaMetric metric = new KafkaMetric(this, m.name(), m.stat(), config == null ? this.config : config, this.time);
            this.registry.registerMetric(metric);
            this.metrics.add(metric);
        }
    }

    public void add(MetricName metricName, MeasurableStat stat) {
        this.add(metricName, stat, null);
    }

    public synchronized void add(MetricName metricName, MeasurableStat stat, MetricConfig config) {
        KafkaMetric metric = new KafkaMetric(new Object(), (MetricName)Utils.notNull((Object)metricName), (Measurable)Utils.notNull((Object)stat), config == null ? this.config : config, this.time);
        this.registry.registerMetric(metric);
        this.metrics.add(metric);
        this.stats.add(stat);
    }

    synchronized List<KafkaMetric> metrics() {
        return Collections.unmodifiableList(this.metrics);
    }
}

