/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.crn;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.crn.ConfluentResourceName;
import io.confluent.crn.CrnPatternMatcher;
import io.confluent.crn.CrnSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class CachedCrnStringPatternMatcher<T> {
    private final CrnPatternMatcher<T> matcher;
    private final int capacity;
    private final Map<String, Optional<Map.Entry<ConfluentResourceName, T>>> cache;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public CachedCrnStringPatternMatcher(CrnPatternMatcher<T> matcher, final int capacity) {
        this.matcher = matcher;
        this.capacity = capacity;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<String, Optional<Map.Entry<ConfluentResourceName, T>>>(this.capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > capacity;
            }
        });
    }

    @VisibleForTesting
    Optional<Map.Entry<ConfluentResourceName, T>> matchEntry(String crnString) {
        return this.cache.computeIfAbsent(crnString, k -> {
            try {
                return Optional.ofNullable(this.matcher.matchEntry(ConfluentResourceName.fromString(crnString)));
            }
            catch (CrnSyntaxException e) {
                return Optional.empty();
            }
        });
    }

    public T match(String crnString) {
        Optional<Map.Entry<ConfluentResourceName, Map.Entry>> entry = this.matchEntry(crnString);
        return entry.map(Map.Entry::getValue).orElse(null);
    }

    public int size() {
        return this.cache.size();
    }

    public String toString() {
        return "CachedCrnStringPatternMatcher(matcher=" + this.matcher + ")";
    }

    public static class Builder<T> {
        private Integer capacity = null;
        private Map<String, T> patterns = new HashMap<String, T>();

        public Builder<T> capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder<T> setPattern(String crnString, T value) {
            this.patterns.put(crnString, value);
            return this;
        }

        public CachedCrnStringPatternMatcher<T> build() throws CrnSyntaxException {
            CrnPatternMatcher.Builder<T> builder = CrnPatternMatcher.builder();
            for (Map.Entry<String, T> entry : this.patterns.entrySet()) {
                builder.setPattern(ConfluentResourceName.fromString(entry.getKey()), entry.getValue());
            }
            return new CachedCrnStringPatternMatcher(builder.build(), this.capacity);
        }
    }
}

