/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import io.confluent.rest.BeginShutdownControllerHandle;
import io.confluent.rest.CheckReadyControllerHandle;
import io.confluent.rest.ControllerReadyHandler;
import io.confluent.rest.ControllerRollHandler;
import java.util.Objects;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerInternalRestServer {
    private static final Logger log = LoggerFactory.getLogger(ControllerInternalRestServer.class);
    private final BeginShutdownControllerHandle beginShutdownControllerHandle;
    private final CheckReadyControllerHandle checkReadyControllerHandle;
    private final int port;
    private Server server;

    public ControllerInternalRestServer(int port, BeginShutdownControllerHandle beginShutdownControllerHandle, CheckReadyControllerHandle checkReadyControllerHandle) {
        this.port = port;
        this.beginShutdownControllerHandle = Objects.requireNonNull(beginShutdownControllerHandle, "null beginShutdownControllerHandle");
        this.checkReadyControllerHandle = Objects.requireNonNull(checkReadyControllerHandle, "null controllerReadinessHandle");
    }

    public synchronized void start() throws Exception {
        if (this.server != null) {
            throw new IllegalStateException("Server is already running.");
        }
        log.info("Binding to port " + this.port);
        this.server = new Server(this.port);
        ContextHandler rollContext = new ContextHandler("/v1/roll");
        rollContext.setHandler((Handler)new ControllerRollHandler(this.beginShutdownControllerHandle));
        ContextHandler readyContext = new ContextHandler("/v1/ready");
        readyContext.setHandler((Handler)new ControllerReadyHandler(this.checkReadyControllerHandle));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        contexts.setHandlers(new Handler[]{rollContext, readyContext, new DefaultHandler()});
        this.server.setHandler((Handler)contexts);
        this.server.start();
    }

    public synchronized void stop() throws Exception {
        if (this.server == null) {
            throw new IllegalStateException("Server is not running.");
        }
        log.info("Stopping");
        this.beginShutdownControllerHandle.close();
        this.server.stop();
        this.server.join();
        this.server = null;
    }
}

