/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rest.CheckReadyControllerHandle;
import io.confluent.rest.CheckReadyControllerStatus;
import io.confluent.rest.ControllerInternalRestServer;
import io.confluent.rest.ResponseContainer;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerReadyHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ControllerInternalRestServer.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final CheckReadyControllerHandle checkReadyControllerHandle;

    public ControllerReadyHandler(CheckReadyControllerHandle checkReadyControllerHandle) {
        this.checkReadyControllerHandle = Objects.requireNonNull(checkReadyControllerHandle);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (target.equals("/status")) {
            log.debug("Handling readiness status query");
            this.handleReadinessQuery(response);
        }
    }

    private void handleReadinessQuery(HttpServletResponse response) throws IOException {
        try {
            CheckReadyControllerStatus status = this.checkReadyControllerHandle.generateReadinessStatus();
            ResponseContainer.dataResponse(status).write(OBJECT_MAPPER, response);
        }
        catch (Exception e) {
            String failureMessage = "Failed to retrieve and write controller readiness information";
            log.error(failureMessage, (Throwable)e);
            ResponseContainer.ErrorResponse resp = ControllerReadyHandler.genericErrorResponse(failureMessage);
            ResponseContainer.errorResponse(Collections.singletonList(resp)).write(OBJECT_MAPPER, response);
        }
    }

    private static ResponseContainer.ErrorResponse genericErrorResponse(String message) {
        return new ResponseContainer.ErrorResponse(0, 500, message);
    }
}

