/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDeConfig;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaAvroSerDe {
    protected static final byte MAGIC_BYTE = 0;
    protected static final int idSize = 4;
    private static final Map<String, Schema> primitiveSchemas;
    protected SchemaRegistryClient schemaRegistry;

    private static Schema createPrimitiveSchema(Schema.Parser parser, String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return parser.parse(schemaString);
    }

    protected static Map<String, Schema> getPrimitiveSchemas() {
        return Collections.unmodifiableMap(primitiveSchemas);
    }

    protected void configureClientProperties(AbstractKafkaAvroSerDeConfig config) {
        try {
            List<String> urls = config.getSchemaRegistryUrls();
            int maxSchemaObject = config.getMaxSchemasPerSubject();
            if (null == this.schemaRegistry) {
                this.schemaRegistry = new CachedSchemaRegistryClient(urls, maxSchemaObject);
            }
        }
        catch (io.confluent.common.config.ConfigException e) {
            throw new ConfigException(e.getMessage());
        }
    }

    protected static String getSubjectName(String topic, boolean isKey) {
        if (isKey) {
            return topic + "-key";
        }
        return topic + "-value";
    }

    protected static String getOldSubjectName(Object value) {
        if (value instanceof GenericContainer) {
            return ((GenericContainer)value).getSchema().getName() + "-value";
        }
        throw new SerializationException("Primitive types are not supported yet");
    }

    protected Schema getSchema(Object object) {
        if (object == null) {
            return primitiveSchemas.get("Null");
        }
        if (object instanceof Boolean) {
            return primitiveSchemas.get("Boolean");
        }
        if (object instanceof Integer) {
            return primitiveSchemas.get("Integer");
        }
        if (object instanceof Long) {
            return primitiveSchemas.get("Long");
        }
        if (object instanceof Float) {
            return primitiveSchemas.get("Float");
        }
        if (object instanceof Double) {
            return primitiveSchemas.get("Double");
        }
        if (object instanceof CharSequence) {
            return primitiveSchemas.get("String");
        }
        if (object instanceof byte[]) {
            return primitiveSchemas.get("Bytes");
        }
        if (object instanceof GenericContainer) {
            return ((GenericContainer)object).getSchema();
        }
        throw new IllegalArgumentException("Unsupported Avro type. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord");
    }

    public int register(String subject, Schema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    public Schema getById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getById(id);
    }

    public Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getBySubjectAndId(subject, id);
    }

    static {
        Schema.Parser parser = new Schema.Parser();
        primitiveSchemas = new HashMap<String, Schema>();
        primitiveSchemas.put("Null", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "null"));
        primitiveSchemas.put("Boolean", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "boolean"));
        primitiveSchemas.put("Integer", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "int"));
        primitiveSchemas.put("Long", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "long"));
        primitiveSchemas.put("Float", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "float"));
        primitiveSchemas.put("Double", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "double"));
        primitiveSchemas.put("String", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "string"));
        primitiveSchemas.put("Bytes", AbstractKafkaAvroSerDe.createPrimitiveSchema(parser, "bytes"));
    }
}

