/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.common.config.ConfigException;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDeConfig;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaAvroSerDe {
    protected static final byte MAGIC_BYTE = 0;
    protected static final int idSize = 4;
    protected SchemaRegistryClient schemaRegistry;
    protected Object keySubjectNameStrategy = new TopicNameStrategy();
    protected Object valueSubjectNameStrategy = new TopicNameStrategy();

    protected void configureClientProperties(AbstractKafkaAvroSerDeConfig config) {
        try {
            List<String> urls = config.getSchemaRegistryUrls();
            int maxSchemaObject = config.getMaxSchemasPerSubject();
            Map originals = config.originalsWithPrefix("");
            if (null == this.schemaRegistry) {
                this.schemaRegistry = new CachedSchemaRegistryClient(urls, maxSchemaObject, originals);
            }
            this.keySubjectNameStrategy = config.keySubjectNameStrategy();
            this.valueSubjectNameStrategy = config.valueSubjectNameStrategy();
        }
        catch (ConfigException e) {
            throw new org.apache.kafka.common.config.ConfigException(e.getMessage());
        }
    }

    protected String getSubjectName(String topic, boolean isKey, Object value, Schema schema) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        if (subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy) {
            return ((io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy)subjectNameStrategy).subjectName(topic, isKey, schema);
        }
        return ((SubjectNameStrategy)subjectNameStrategy).getSubjectName(topic, isKey, value);
    }

    protected boolean isDeprecatedSubjectNameStrategy(boolean isKey) {
        Object subjectNameStrategy = this.subjectNameStrategy(isKey);
        return !(subjectNameStrategy instanceof io.confluent.kafka.serializers.subject.strategy.SubjectNameStrategy);
    }

    private Object subjectNameStrategy(boolean isKey) {
        return isKey ? this.keySubjectNameStrategy : this.valueSubjectNameStrategy;
    }

    protected String getOldSubjectName(Object value) {
        if (value instanceof GenericContainer) {
            return ((GenericContainer)value).getSchema().getName() + "-value";
        }
        throw new SerializationException("Primitive types are not supported yet");
    }

    public int register(String subject, Schema schema) throws IOException, RestClientException {
        return this.schemaRegistry.register(subject, schema);
    }

    public Schema getById(int id) throws IOException, RestClientException {
        return this.schemaRegistry.getById(id);
    }

    public Schema getBySubjectAndId(String subject, int id) throws IOException, RestClientException {
        return this.schemaRegistry.getBySubjectAndId(subject, id);
    }
}

