/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDe;
import io.confluent.kafka.serializers.AvroSchemaUtils;
import io.confluent.kafka.serializers.GenericContainerWithVersion;
import io.confluent.kafka.serializers.KafkaAvroDeserializerConfig;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kafka.utils.VerifiableProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.kafka.common.errors.SerializationException;

public abstract class AbstractKafkaAvroDeserializer
extends AbstractKafkaAvroSerDe {
    private final DecoderFactory decoderFactory = DecoderFactory.get();
    protected boolean useSpecificAvroReader = false;
    private final Map<String, Schema> readerSchemaCache = new ConcurrentHashMap<String, Schema>();

    protected void configure(KafkaAvroDeserializerConfig config) {
        this.configureClientProperties(config);
        this.useSpecificAvroReader = config.getBoolean("specific.avro.reader");
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(Map<String, ?> props) {
        return new KafkaAvroDeserializerConfig(props);
    }

    protected KafkaAvroDeserializerConfig deserializerConfig(VerifiableProperties props) {
        return new KafkaAvroDeserializerConfig(props.props());
    }

    private ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    protected Object deserialize(byte[] payload) throws SerializationException {
        return this.deserialize(null, null, payload, null);
    }

    protected Object deserialize(byte[] payload, Schema readerSchema) throws SerializationException {
        return this.deserialize(null, null, payload, readerSchema);
    }

    protected Object deserialize(String topic, Boolean isKey, byte[] payload, Schema readerSchema) throws SerializationException {
        if (payload == null) {
            return null;
        }
        DeserializationContext context = new DeserializationContext(topic, isKey, payload);
        return context.read(context.schemaFromRegistry(), readerSchema);
    }

    private Integer schemaVersion(String topic, Boolean isKey, int id, String subject, Schema schema, Object result) throws IOException, RestClientException {
        Integer version;
        if (this.isDeprecatedSubjectNameStrategy(isKey)) {
            subject = this.getSubjectName(topic, isKey, result, schema);
            Schema subjectSchema = this.schemaRegistry.getBySubjectAndId(subject, id);
            version = this.schemaRegistry.getVersion(subject, subjectSchema);
        } else {
            version = this.schemaRegistry.getVersion(subject, schema);
        }
        return version;
    }

    private String subjectName(String topic, Boolean isKey, Schema schemaFromRegistry) {
        return this.isDeprecatedSubjectNameStrategy(isKey) ? null : this.getSubjectName(topic, isKey, null, schemaFromRegistry);
    }

    protected GenericContainerWithVersion deserializeWithSchemaAndVersion(String topic, boolean isKey, byte[] payload) throws SerializationException {
        if (payload == null) {
            return null;
        }
        DeserializationContext context = new DeserializationContext(topic, isKey, payload);
        Schema schema = context.schemaForDeserialize();
        Object result = context.read(schema, null);
        try {
            Integer version = this.schemaVersion(topic, isKey, context.getSchemaId(), context.getSubject(), schema, result);
            if (schema.getType().equals((Object)Schema.Type.RECORD)) {
                return new GenericContainerWithVersion((GenericContainer)result, version);
            }
            return new GenericContainerWithVersion(new NonRecordContainer(schema, result), version);
        }
        catch (RestClientException | IOException e) {
            throw new SerializationException("Error retrieving Avro schema version for id " + context.getSchemaId(), e);
        }
    }

    private DatumReader<?> getDatumReader(Schema writerSchema, Schema readerSchema) {
        boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().values().contains(writerSchema);
        if (this.useSchemaReflection && !writerSchemaIsPrimitive) {
            if (readerSchema == null) {
                throw new SerializationException("Reader schema cannot be null when using Avro schema reflection");
            }
            return new ReflectDatumReader(writerSchema, readerSchema);
        }
        if (this.useSpecificAvroReader && !writerSchemaIsPrimitive) {
            if (readerSchema == null) {
                readerSchema = this.getReaderSchema(writerSchema);
            }
            return new SpecificDatumReader(writerSchema, readerSchema);
        }
        if (readerSchema == null) {
            return new GenericDatumReader(writerSchema);
        }
        return new GenericDatumReader(writerSchema, readerSchema);
    }

    private Schema getReaderSchema(Schema writerSchema) {
        Schema readerSchema = this.readerSchemaCache.get(writerSchema.getFullName());
        if (readerSchema == null) {
            Class readerClass = SpecificData.get().getClass(writerSchema);
            if (readerClass != null) {
                try {
                    readerSchema = ((SpecificRecord)readerClass.newInstance()).getSchema();
                }
                catch (InstantiationException e) {
                    throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema could not be instantiated to find the readers schema.");
                }
                catch (IllegalAccessException e) {
                    throw new SerializationException(writerSchema.getFullName() + " specified by the writers schema is not allowed to be instantiated to find the readers schema.");
                }
                this.readerSchemaCache.put(writerSchema.getFullName(), readerSchema);
            } else {
                throw new SerializationException("Could not find class " + writerSchema.getFullName() + " specified in writer's schema whilst finding reader's schema for a SpecificRecord.");
            }
        }
        return readerSchema;
    }

    class DeserializationContext {
        private final String topic;
        private final Boolean isKey;
        private final ByteBuffer buffer;
        private final int schemaId;

        DeserializationContext(String topic, Boolean isKey, byte[] payload) {
            this.topic = topic;
            this.isKey = isKey;
            this.buffer = AbstractKafkaAvroDeserializer.this.getByteBuffer(payload);
            this.schemaId = this.buffer.getInt();
        }

        Schema schemaFromRegistry() {
            try {
                return AbstractKafkaAvroDeserializer.this.schemaRegistry.getById(this.schemaId);
            }
            catch (RestClientException | IOException e) {
                throw new SerializationException("Error retrieving Avro schema for id " + this.schemaId, e);
            }
        }

        Schema schemaForDeserialize() {
            try {
                return AbstractKafkaAvroDeserializer.this.isDeprecatedSubjectNameStrategy(this.isKey) ? AvroSchemaUtils.copyOf(this.schemaFromRegistry()) : AbstractKafkaAvroDeserializer.this.schemaRegistry.getBySubjectAndId(this.getSubject(), this.schemaId);
            }
            catch (RestClientException | IOException e) {
                throw new SerializationException("Error retrieving Avro schema for id " + this.schemaId, e);
            }
        }

        String getSubject() {
            return AbstractKafkaAvroDeserializer.this.subjectName(this.topic, this.isKey, this.schemaFromRegistry());
        }

        String getTopic() {
            return this.topic;
        }

        boolean isKey() {
            return this.isKey;
        }

        int getSchemaId() {
            return this.schemaId;
        }

        Object read(Schema writerSchema) {
            return this.read(writerSchema, null);
        }

        Object read(Schema writerSchema, Schema readerSchema) {
            DatumReader reader = AbstractKafkaAvroDeserializer.this.getDatumReader(writerSchema, readerSchema);
            int length = this.buffer.limit() - 1 - 4;
            if (writerSchema.getType().equals((Object)Schema.Type.BYTES)) {
                byte[] bytes = new byte[length];
                this.buffer.get(bytes, 0, length);
                return bytes;
            }
            int start = this.buffer.position() + this.buffer.arrayOffset();
            try {
                Object result = reader.read(null, (Decoder)AbstractKafkaAvroDeserializer.this.decoderFactory.binaryDecoder(this.buffer.array(), start, length, null));
                if (writerSchema.getType().equals((Object)Schema.Type.STRING)) {
                    return result.toString();
                }
                return result;
            }
            catch (IOException | RuntimeException e) {
                throw new SerializationException("Error deserializing Avro message for id " + this.schemaId, (Throwable)e);
            }
        }
    }
}

