/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.hdfs.HdfsSinkConnectorConstants;
import io.confluent.connect.hdfs.filter.CommittedFileFilter;
import io.confluent.connect.hdfs.storage.Storage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static String logFileName(String url, String logsDir, TopicPartition topicPart) {
        return FileUtils.fileName(url, logsDir, topicPart, "log");
    }

    public static String directoryName(String url, String topicsDir, TopicPartition topicPart) {
        String topic = topicPart.topic();
        int partition = topicPart.partition();
        return url + "/" + topicsDir + "/" + topic + "/" + partition;
    }

    public static String directoryName(String url, String topicsDir, String directory) {
        return url + "/" + topicsDir + "/" + directory;
    }

    public static String fileName(String url, String topicsDir, TopicPartition topicPart, String name) {
        String topic = topicPart.topic();
        int partition = topicPart.partition();
        return url + "/" + topicsDir + "/" + topic + "/" + partition + "/" + name;
    }

    public static String fileName(String url, String topicsDir, String directory, String name) {
        return url + "/" + topicsDir + "/" + directory + "/" + name;
    }

    public static String tempFileName(String url, String topicsDir, String directory, String extension) {
        UUID id = UUID.randomUUID();
        String name = id.toString() + "_tmp" + extension;
        return FileUtils.fileName(url, topicsDir, directory, name);
    }

    public static String committedFileName(String url, String topicsDir, String directory, TopicPartition topicPart, long startOffset, long endOffset, String extension, String zeroPadFormat) {
        String topic = topicPart.topic();
        int partition = topicPart.partition();
        StringBuilder sb = new StringBuilder();
        sb.append(topic);
        sb.append("+");
        sb.append(partition);
        sb.append("+");
        sb.append(String.format(zeroPadFormat, startOffset));
        sb.append("+");
        sb.append(String.format(zeroPadFormat, endOffset));
        sb.append(extension);
        String name = sb.toString();
        return FileUtils.fileName(url, topicsDir, directory, name);
    }

    public static String topicDirectory(String url, String topicsDir, String topic) {
        return url + "/" + topicsDir + "/" + topic;
    }

    public static FileStatus fileStatusWithMaxOffset(Storage storage, Path path, CommittedFileFilter filter) {
        if (!storage.exists(path.toString())) {
            return null;
        }
        long maxOffset = -1L;
        FileStatus fileStatusWithMaxOffset = null;
        List statuses = (List)storage.list(path.toString());
        for (FileStatus status : statuses) {
            long offset;
            if (status.isDirectory()) {
                FileStatus fileStatus = FileUtils.fileStatusWithMaxOffset(storage, status.getPath(), filter);
                if (fileStatus == null || (offset = FileUtils.extractOffset(fileStatus.getPath().getName())) <= maxOffset) continue;
                maxOffset = offset;
                fileStatusWithMaxOffset = fileStatus;
                continue;
            }
            String filename = status.getPath().getName();
            log.trace("Checked for max offset: {}", (Object)status.getPath());
            if (!filter.accept(status.getPath()) || (offset = FileUtils.extractOffset(filename)) <= maxOffset) continue;
            maxOffset = offset;
            fileStatusWithMaxOffset = status;
        }
        return fileStatusWithMaxOffset;
    }

    public static long extractOffset(String filename) {
        Matcher m = HdfsSinkConnectorConstants.COMMITTED_FILENAME_PATTERN.matcher(filename);
        if (!m.matches()) {
            throw new IllegalArgumentException(filename + " does not match COMMITTED_FILENAME_PATTERN");
        }
        return Long.parseLong(m.group(4));
    }

    private static ArrayList<FileStatus> getDirectoriesImpl(Storage storage, Path path) {
        List statuses = (List)storage.list(path.toString());
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus status : statuses) {
            if (!status.isDirectory()) continue;
            int count = 0;
            List fileStatuses = (List)storage.list(status.getPath().toString());
            for (FileStatus fileStatus : fileStatuses) {
                if (fileStatus.isDirectory()) {
                    result.addAll(FileUtils.getDirectoriesImpl(storage, fileStatus.getPath()));
                    continue;
                }
                ++count;
            }
            if (count != fileStatuses.size()) continue;
            result.add(status);
        }
        return result;
    }

    public static FileStatus[] getDirectories(Storage storage, Path path) throws IOException {
        ArrayList<FileStatus> result = FileUtils.getDirectoriesImpl(storage, path);
        return result.toArray(new FileStatus[result.size()]);
    }

    private static ArrayList<FileStatus> traverseImpl(Storage storage, Path path, PathFilter filter) {
        if (!storage.exists(path.toString())) {
            return new ArrayList<FileStatus>();
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        List statuses = (List)storage.list(path.toString());
        for (FileStatus status : statuses) {
            if (status.isDirectory()) {
                result.addAll(FileUtils.traverseImpl(storage, status.getPath(), filter));
                continue;
            }
            if (!filter.accept(status.getPath())) continue;
            result.add(status);
        }
        return result;
    }

    private static ArrayList<FileStatus> traverseImpl(FileSystem fs, Path path) throws IOException {
        FileStatus[] statuses;
        if (!fs.exists(path)) {
            return new ArrayList<FileStatus>();
        }
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        for (FileStatus status : statuses = fs.listStatus(path)) {
            if (status.isDirectory()) {
                result.addAll(FileUtils.traverseImpl(fs, status.getPath()));
                continue;
            }
            result.add(status);
        }
        return result;
    }

    public static FileStatus[] traverse(Storage storage, Path path, PathFilter filter) throws IOException {
        ArrayList<FileStatus> result = FileUtils.traverseImpl(storage, path, filter);
        return result.toArray(new FileStatus[result.size()]);
    }

    public static FileStatus[] traverse(FileSystem fs, Path path) throws IOException {
        ArrayList<FileStatus> result = FileUtils.traverseImpl(fs, path);
        return result.toArray(new FileStatus[result.size()]);
    }
}

