/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.HdfsSinkTask;
import io.confluent.connect.hdfs.Version;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.sink.SinkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsSinkConnector
extends SinkConnector {
    public static final String TASK_ID_CONFIG_NAME = "task.id";
    private static final Logger log = LoggerFactory.getLogger(HdfsSinkConnector.class);
    private Map<String, String> configProperties;
    private HdfsSinkConnectorConfig config;

    public String version() {
        return Version.getVersion();
    }

    public void start(Map<String, String> props) throws ConnectException {
        try {
            this.configProperties = props;
            this.config = new HdfsSinkConnectorConfig(props);
        }
        catch (ConfigException e) {
            throw new ConnectException("Couldn't start HdfsSinkConnector due to configuration error", (Throwable)e);
        }
    }

    public Class<? extends Task> taskClass() {
        return HdfsSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>();
        for (int i = 0; i < maxTasks; ++i) {
            HashMap<String, String> taskProps = new HashMap<String, String>(this.configProperties);
            taskProps.put(TASK_ID_CONFIG_NAME, Integer.toString(i));
            taskConfigs.add(taskProps);
        }
        return taskConfigs;
    }

    public void stop() throws ConnectException {
    }

    public ConfigDef config() {
        return HdfsSinkConnectorConfig.getConfig();
    }
}

