/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs;

import io.confluent.connect.hdfs.avro.AvroFormat;
import io.confluent.connect.hdfs.json.JsonFormat;
import io.confluent.connect.hdfs.orc.OrcFormat;
import io.confluent.connect.hdfs.parquet.ParquetFormat;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.hdfs.string.StringFormat;
import io.confluent.connect.storage.StorageSinkConnectorConfig;
import io.confluent.connect.storage.common.ComposableConfig;
import io.confluent.connect.storage.common.GenericRecommender;
import io.confluent.connect.storage.common.ParentValueRecommender;
import io.confluent.connect.storage.common.StorageCommonConfig;
import io.confluent.connect.storage.hive.HiveConfig;
import io.confluent.connect.storage.partitioner.DailyPartitioner;
import io.confluent.connect.storage.partitioner.DefaultPartitioner;
import io.confluent.connect.storage.partitioner.FieldPartitioner;
import io.confluent.connect.storage.partitioner.HourlyPartitioner;
import io.confluent.connect.storage.partitioner.PartitionerConfig;
import io.confluent.connect.storage.partitioner.TimeBasedPartitioner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public class HdfsSinkConnectorConfig
extends StorageSinkConnectorConfig {
    private static final String TOPIC_SUBSTITUTION = "${topic}";
    public static final String HDFS_URL_CONFIG = "hdfs.url";
    public static final String HDFS_URL_DOC = "The HDFS connection URL. This configuration has the format of hdfs://hostname:port and specifies the HDFS to export data to. This property is deprecated and will be removed in future releases. Use ``store.url`` instead.";
    public static final String HDFS_URL_DEFAULT = null;
    public static final String HDFS_URL_DISPLAY = "HDFS URL";
    public static final String HADOOP_CONF_DIR_CONFIG = "hadoop.conf.dir";
    public static final String HADOOP_CONF_DIR_DEFAULT = "";
    private static final String HADOOP_CONF_DIR_DOC = "The Hadoop configuration directory.";
    private static final String HADOOP_CONF_DIR_DISPLAY = "Hadoop Configuration Directory";
    public static final String HADOOP_HOME_CONFIG = "hadoop.home";
    public static final String HADOOP_HOME_DEFAULT = "";
    private static final String HADOOP_HOME_DOC = "The Hadoop home directory.";
    private static final String HADOOP_HOME_DISPLAY = "Hadoop home directory";
    public static final String HIVE_TABLE_NAME_CONFIG = "hive.table.name";
    public static final String HIVE_TABLE_NAME_DEFAULT = "${topic}";
    private static final String HIVE_TABLE_NAME_DOC = "The hive table name to use. It must contain '${topic}' to inject the corresponding topic name.";
    private static final String HIVE_TABLE_NAME_DISPLAY = "Hive table name";
    public static final String TOPIC_CAPTURE_GROUPS_REGEX_CONFIG = "topic.capture.groups.regex";
    public static final String TOPIC_CAPTURE_GROUPS_REGEX_DISPLAY = "Topic Capture Groups Regex";
    public static final String TOPIC_CAPTURE_GROUPS_REGEX_DOC = "A Java Pattern regex that matches the entire topic and captures values for substituting into ``topics.dir``. Indexed capture groups are accessible with ``${n}``, where ``${0}`` refers to the whole match and ``${1}`` refers to the first capture group. Example config value of ``([a-zA-Z]*)_([a-zA-Z]*)`` will match topics that are two words delimited by an underscore and will capture each word separately. With ``topic.dir = ${1}/${2}``, a record from the topic ``example_name`` will be written into a subdirectory of ``example/name/``. By default, this functionality is not enabled.";
    public static final String TOPIC_CAPTURE_GROUPS_REGEX_DEFAULT = null;
    private static final String DIR_REGEX_DOC = " Supports ``${topic}`` in the value, which will be replaced by the actual topic name. Supports ``${0}``, ..., ``${n}`` in conjunction with topic.capture.groups.regex. See topic.capture.groups.regex configuration documentation for details.";
    public static final String LOGS_DIR_CONFIG = "logs.dir";
    public static final String LOGS_DIR_DOC = "Top level directory to store the write ahead logs. Supports ``${topic}`` in the value, which will be replaced by the actual topic name. Supports ``${0}``, ..., ``${n}`` in conjunction with topic.capture.groups.regex. See topic.capture.groups.regex configuration documentation for details.";
    public static final String LOGS_DIR_DEFAULT = "logs";
    public static final String LOGS_DIR_DISPLAY = "Logs directory";
    public static final String HDFS_AUTHENTICATION_KERBEROS_CONFIG = "hdfs.authentication.kerberos";
    private static final String HDFS_AUTHENTICATION_KERBEROS_DOC = "Configuration indicating whether HDFS is using Kerberos for authentication.";
    private static final boolean HDFS_AUTHENTICATION_KERBEROS_DEFAULT = false;
    private static final String HDFS_AUTHENTICATION_KERBEROS_DISPLAY = "HDFS Authentication Kerberos";
    public static final String CONNECT_HDFS_PRINCIPAL_CONFIG = "connect.hdfs.principal";
    public static final String CONNECT_HDFS_PRINCIPAL_DEFAULT = "";
    private static final String CONNECT_HDFS_PRINCIPAL_DOC = "The principal to use when HDFS is using Kerberos to for authentication.";
    private static final String CONNECT_HDFS_PRINCIPAL_DISPLAY = "Connect Kerberos Principal";
    public static final String CONNECT_HDFS_KEYTAB_CONFIG = "connect.hdfs.keytab";
    public static final String CONNECT_HDFS_KEYTAB_DEFAULT = "";
    private static final String CONNECT_HDFS_KEYTAB_DOC = "The path to the keytab file for the HDFS connector principal. This keytab file should only be readable by the connector user.";
    private static final String CONNECT_HDFS_KEYTAB_DISPLAY = "Connect Kerberos Keytab";
    public static final String HDFS_NAMENODE_PRINCIPAL_CONFIG = "hdfs.namenode.principal";
    public static final String HDFS_NAMENODE_PRINCIPAL_DEFAULT = "";
    private static final String HDFS_NAMENODE_PRINCIPAL_DOC = "The principal for HDFS Namenode.";
    private static final String HDFS_NAMENODE_PRINCIPAL_DISPLAY = "HDFS NameNode Kerberos Principal";
    public static final String KERBEROS_TICKET_RENEW_PERIOD_MS_CONFIG = "kerberos.ticket.renew.period.ms";
    public static final long KERBEROS_TICKET_RENEW_PERIOD_MS_DEFAULT = 3600000L;
    private static final String KERBEROS_TICKET_RENEW_PERIOD_MS_DOC = "The period in milliseconds to renew the Kerberos ticket.";
    private static final String KERBEROS_TICKET_RENEW_PERIOD_MS_DISPLAY = "Kerberos Ticket Renew Period (ms)";
    private static final Pattern SUBSTITUTION_PATTERN = Pattern.compile("\\$\\{(\\d+)}");
    private static final Pattern INVALID_SUB_PATTERN = Pattern.compile("\\$\\{.*}");
    private static final ConfigDef.Recommender hdfsAuthenticationKerberosDependentsRecommender = new BooleanParentRecommender("hdfs.authentication.kerberos");
    private static final GenericRecommender STORAGE_CLASS_RECOMMENDER = new GenericRecommender();
    private static final GenericRecommender FORMAT_CLASS_RECOMMENDER = new GenericRecommender();
    private static final GenericRecommender PARTITIONER_CLASS_RECOMMENDER = new GenericRecommender();
    private static final ParentValueRecommender AVRO_COMPRESSION_RECOMMENDER = new ParentValueRecommender("format.class", AvroFormat.class, (Object[])AVRO_SUPPORTED_CODECS);
    private final String url;
    private final StorageCommonConfig commonConfig;
    private final HiveConfig hiveConfig;
    private final PartitionerConfig partitionerConfig;
    private final Pattern topicRegexCaptureGroup;
    private final Map<String, ComposableConfig> propertyToConfig = new HashMap<String, ComposableConfig>();
    private final Set<AbstractConfig> allConfigs = new HashSet<AbstractConfig>();
    private Configuration hadoopConfig;
    private int topicDirGroupsMaxIndex;
    private int logDirGroupsMaxIndex;
    private int taskId;

    public static ConfigDef newConfigDef() {
        ConfigDef configDef = new ConfigDef();
        String group = "HDFS";
        int orderInGroup = 0;
        configDef.define(HDFS_URL_CONFIG, ConfigDef.Type.STRING, (Object)HDFS_URL_DEFAULT, ConfigDef.Importance.HIGH, HDFS_URL_DOC, "HDFS", ++orderInGroup, ConfigDef.Width.MEDIUM, HDFS_URL_DISPLAY);
        configDef.define(HADOOP_CONF_DIR_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, HADOOP_CONF_DIR_DOC, "HDFS", ++orderInGroup, ConfigDef.Width.MEDIUM, HADOOP_CONF_DIR_DISPLAY);
        configDef.define(HADOOP_HOME_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, HADOOP_HOME_DOC, "HDFS", ++orderInGroup, ConfigDef.Width.SHORT, HADOOP_HOME_DISPLAY);
        configDef.define(LOGS_DIR_CONFIG, ConfigDef.Type.STRING, (Object)LOGS_DIR_DEFAULT, ConfigDef.Importance.HIGH, LOGS_DIR_DOC, "HDFS", ++orderInGroup, ConfigDef.Width.SHORT, LOGS_DIR_DISPLAY);
        configDef.define(HIVE_TABLE_NAME_CONFIG, ConfigDef.Type.STRING, (Object)"${topic}", ConfigDef.Importance.LOW, HIVE_TABLE_NAME_DOC, "HDFS", ++orderInGroup, ConfigDef.Width.SHORT, HIVE_TABLE_NAME_DISPLAY);
        group = "Security";
        orderInGroup = 0;
        configDef.define(HDFS_AUTHENTICATION_KERBEROS_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, HDFS_AUTHENTICATION_KERBEROS_DOC, "Security", ++orderInGroup, ConfigDef.Width.SHORT, HDFS_AUTHENTICATION_KERBEROS_DISPLAY, Arrays.asList(CONNECT_HDFS_PRINCIPAL_CONFIG, CONNECT_HDFS_KEYTAB_CONFIG, HDFS_NAMENODE_PRINCIPAL_CONFIG, KERBEROS_TICKET_RENEW_PERIOD_MS_CONFIG));
        configDef.define(CONNECT_HDFS_PRINCIPAL_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, CONNECT_HDFS_PRINCIPAL_DOC, "Security", ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECT_HDFS_PRINCIPAL_DISPLAY, hdfsAuthenticationKerberosDependentsRecommender);
        configDef.define(CONNECT_HDFS_KEYTAB_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, CONNECT_HDFS_KEYTAB_DOC, "Security", ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECT_HDFS_KEYTAB_DISPLAY, hdfsAuthenticationKerberosDependentsRecommender);
        configDef.define(HDFS_NAMENODE_PRINCIPAL_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, HDFS_NAMENODE_PRINCIPAL_DOC, "Security", ++orderInGroup, ConfigDef.Width.MEDIUM, HDFS_NAMENODE_PRINCIPAL_DISPLAY, hdfsAuthenticationKerberosDependentsRecommender);
        configDef.define(KERBEROS_TICKET_RENEW_PERIOD_MS_CONFIG, ConfigDef.Type.LONG, (Object)3600000L, ConfigDef.Importance.LOW, KERBEROS_TICKET_RENEW_PERIOD_MS_DOC, "Security", ++orderInGroup, ConfigDef.Width.SHORT, KERBEROS_TICKET_RENEW_PERIOD_MS_DISPLAY, hdfsAuthenticationKerberosDependentsRecommender);
        ConfigDef storageConfigDef = StorageSinkConnectorConfig.newConfigDef((ConfigDef.Recommender)FORMAT_CLASS_RECOMMENDER, (ConfigDef.Recommender)AVRO_COMPRESSION_RECOMMENDER);
        int lastOrder = 0;
        String group2 = "Storage";
        for (ConfigDef.ConfigKey key : storageConfigDef.configKeys().values()) {
            configDef.define(key);
            lastOrder = Math.max(key.orderInGroup, lastOrder);
        }
        configDef.define(TOPIC_CAPTURE_GROUPS_REGEX_CONFIG, ConfigDef.Type.STRING, (Object)TOPIC_CAPTURE_GROUPS_REGEX_DEFAULT, ConfigDef.Importance.LOW, TOPIC_CAPTURE_GROUPS_REGEX_DOC, group2, ++lastOrder, ConfigDef.Width.LONG, TOPIC_CAPTURE_GROUPS_REGEX_DISPLAY);
        return configDef;
    }

    public HdfsSinkConnectorConfig(Map<String, String> props) {
        this(HdfsSinkConnectorConfig.newConfigDef(), HdfsSinkConnectorConfig.addDefaults(props));
    }

    protected HdfsSinkConnectorConfig(ConfigDef configDef, Map<String, String> props) {
        super(configDef, props);
        ConfigDef storageCommonConfigDef = StorageCommonConfig.newConfigDef((ConfigDef.Recommender)STORAGE_CLASS_RECOMMENDER);
        this.commonConfig = new StorageCommonConfig(storageCommonConfigDef, this.originalsStrings());
        this.hiveConfig = new HiveConfig(this.originalsStrings());
        ConfigDef partitionerConfigDef = PartitionerConfig.newConfigDef((ConfigDef.Recommender)PARTITIONER_CLASS_RECOMMENDER);
        this.partitionerConfig = new PartitionerConfig(partitionerConfigDef, this.originalsStrings());
        this.hadoopConfig = new Configuration();
        this.taskId = props.get("task.id") != null ? Integer.parseInt(props.get("task.id")) : -1;
        this.addToGlobal((AbstractConfig)this.hiveConfig);
        this.addToGlobal((AbstractConfig)this.partitionerConfig);
        this.addToGlobal((AbstractConfig)this.commonConfig);
        this.addToGlobal((AbstractConfig)this);
        this.url = this.extractUrl();
        try {
            String topicRegex = this.getString(TOPIC_CAPTURE_GROUPS_REGEX_CONFIG);
            this.topicRegexCaptureGroup = topicRegex != null ? Pattern.compile(topicRegex) : null;
        }
        catch (PatternSyntaxException e) {
            throw new ConfigException("topic.capture.groups.regex is an invalid regex pattern: ", (Object)e);
        }
        this.topicDirGroupsMaxIndex = this.getMaxIndexToReplace(this.getString("topics.dir"));
        this.logDirGroupsMaxIndex = this.getMaxIndexToReplace(this.getString(LOGS_DIR_CONFIG));
        this.validateDirsAndRegex();
        this.validateTimezone();
    }

    private void validateTimezone() {
        String timezone = this.getString("timezone");
        long rotateScheduleIntervalMs = this.getLong("rotate.schedule.interval.ms");
        if (rotateScheduleIntervalMs > 0L && timezone.isEmpty()) {
            throw new ConfigException(String.format("%s configuration must be set when using %s", "timezone", "rotate.schedule.interval.ms"));
        }
    }

    public static Map<String, String> addDefaults(Map<String, String> props) {
        ConcurrentHashMap<String, String> propsCopy = new ConcurrentHashMap<String, String>(props);
        propsCopy.putIfAbsent("storage.class", HdfsStorage.class.getName());
        propsCopy.putIfAbsent("format.class", AvroFormat.class.getName());
        return propsCopy;
    }

    private void addToGlobal(AbstractConfig config) {
        this.allConfigs.add(config);
        this.addConfig(config.values(), (ComposableConfig)config);
    }

    private void addConfig(Map<String, ?> parsedProps, ComposableConfig config) {
        for (String key : parsedProps.keySet()) {
            this.propertyToConfig.put(key, config);
        }
    }

    private String extractUrl() {
        String storageUrl = this.getString("store.url");
        if (StringUtils.isNotBlank((String)storageUrl)) {
            return storageUrl;
        }
        String hdfsUrl = this.getString(HDFS_URL_CONFIG);
        if (StringUtils.isNotBlank((String)hdfsUrl)) {
            return hdfsUrl;
        }
        throw new ConfigException(String.format("Configuration %s cannot be empty.", "store.url"));
    }

    public String connectHdfsPrincipal() {
        return this.getString(CONNECT_HDFS_PRINCIPAL_CONFIG);
    }

    public String connectHdfsKeytab() {
        return this.getString(CONNECT_HDFS_KEYTAB_CONFIG);
    }

    public String hadoopConfDir() {
        return this.getString(HADOOP_CONF_DIR_CONFIG);
    }

    public String hadoopHome() {
        return this.getString(HADOOP_HOME_CONFIG);
    }

    public String hdfsNamenodePrincipal() {
        return this.getString(HDFS_NAMENODE_PRINCIPAL_CONFIG);
    }

    public boolean kerberosAuthentication() {
        return this.getBoolean(HDFS_AUTHENTICATION_KERBEROS_CONFIG);
    }

    public long kerberosTicketRenewPeriodMs() {
        return this.getLong(KERBEROS_TICKET_RENEW_PERIOD_MS_CONFIG);
    }

    public String logsDir() {
        return this.getString(LOGS_DIR_CONFIG);
    }

    public String name() {
        return this.originalsStrings().getOrDefault("name", "HDFS-sink");
    }

    public String url() {
        return this.url;
    }

    public Object get(String key) {
        ComposableConfig config = this.propertyToConfig.get(key);
        if (config == null) {
            throw new ConfigException(String.format("Unknown configuration '%s'", key));
        }
        return config == this ? super.get(key) : config.get(key);
    }

    public Configuration getHadoopConfiguration() {
        return this.hadoopConfig;
    }

    public Map<String, ?> plainValues() {
        HashMap map = new HashMap();
        for (AbstractConfig config : this.allConfigs) {
            map.putAll(config.values());
        }
        Map originals = this.originals();
        for (String originalKey : originals.keySet()) {
            if (map.containsKey(originalKey)) continue;
            map.put(originalKey, originals.get(originalKey));
        }
        return map;
    }

    public String getLogsDirFromTopic(String topic) {
        return this.getDirFromTopic(this.getString(LOGS_DIR_CONFIG), topic, this.logDirGroupsMaxIndex);
    }

    public String getTopicsDirFromTopic(String topic) {
        return this.getDirFromTopic(this.getString("topics.dir"), topic, this.topicDirGroupsMaxIndex);
    }

    public String getHiveTableName(String topic) {
        return this.getString(HIVE_TABLE_NAME_CONFIG).replace("${topic}", topic);
    }

    private String getDirFromTopic(String dir, String topic, int maxIndexParts) {
        dir = dir.replace("${topic}", topic);
        if (this.topicRegexCaptureGroup != null) {
            Matcher matcher = this.topicRegexCaptureGroup.matcher(topic);
            if (!matcher.matches()) {
                throw new ConfigException(TOPIC_CAPTURE_GROUPS_REGEX_CONFIG, (Object)this.topicRegexCaptureGroup.pattern(), String.format("Topic %s does not fully match the specified regex.", topic));
            }
            if (maxIndexParts > matcher.groupCount()) {
                throw new ConfigException(String.format("Topic %s must have at least %d capture groups using regex pattern %s, but actually had %d capture groups.", topic, maxIndexParts, this.topicRegexCaptureGroup.pattern(), matcher.groupCount()));
            }
            for (int index = 0; index < matcher.groupCount() + 1; ++index) {
                dir = dir.replace("${" + index + "}", matcher.group(index));
            }
        }
        return dir;
    }

    private int getMaxIndexToReplace(String string) {
        ArrayList<Integer> toReplace = new ArrayList<Integer>();
        Matcher partsMatcher = SUBSTITUTION_PATTERN.matcher(string);
        while (partsMatcher.find()) {
            String part = partsMatcher.group();
            if (part.isEmpty() || partsMatcher.groupCount() != 1) continue;
            toReplace.add(Integer.valueOf(partsMatcher.group(1)));
        }
        return toReplace.isEmpty() ? -1 : (Integer)Collections.max(toReplace);
    }

    private void validateDirsAndRegex() {
        if (this.topicDirGroupsMaxIndex >= 0 && this.topicRegexCaptureGroup == null) {
            throw new ConfigException("topics.dir cannot contain ${} without a valid topic.capture.groups.regex being configured.");
        }
        if (this.logDirGroupsMaxIndex >= 0 && this.topicRegexCaptureGroup == null) {
            throw new ConfigException("logs.dir cannot contain ${} without a valid topic.capture.groups.regex being configured.");
        }
        this.validateReplacements("topics.dir");
        this.validateReplacements(LOGS_DIR_CONFIG);
        this.validateHiveTableNameReplacements();
    }

    private void validateHiveTableNameReplacements() {
        String config = HIVE_TABLE_NAME_CONFIG;
        String configValue = this.getString(config);
        if (!configValue.contains("${topic}")) {
            throw new ConfigException(String.format("%s: '%s' has to contain topic substitution '%s'.", config, this.getString(config), "${topic}"));
        }
        String tableName = configValue.replace("${topic}", "");
        Matcher invalidMatcher = INVALID_SUB_PATTERN.matcher(tableName);
        if (invalidMatcher.find()) {
            throw new ConfigException(String.format("%s: '%s' contains an invalid ${} substitution '%s'. Valid substitution is '%s'", config, this.getString(config), invalidMatcher.group(), "${topic}"));
        }
    }

    private void validateReplacements(String config) {
        Matcher partsMatcher = SUBSTITUTION_PATTERN.matcher(this.getString(config));
        String dir = partsMatcher.replaceAll("").replace("${topic}", "");
        Matcher invalidMatcher = INVALID_SUB_PATTERN.matcher(dir);
        if (invalidMatcher.find()) {
            throw new ConfigException(String.format("%s: %s contains an invalid ${} substitution %s. Valid substitutions are %s and ${n} where n >= 0.", config, this.getString(config), invalidMatcher.group(), "${topic}"));
        }
    }

    public static ConfigDef getConfig() {
        HashSet<String> skip = new HashSet<String>();
        skip.add("storage.class");
        skip.add("format.class");
        skip.add("topics.dir");
        ConfigDef visible = new ConfigDef();
        HdfsSinkConnectorConfig.addAllConfigKeys(visible, HdfsSinkConnectorConfig.newConfigDef(), skip);
        HdfsSinkConnectorConfig.addAllConfigKeys(visible, StorageCommonConfig.newConfigDef((ConfigDef.Recommender)STORAGE_CLASS_RECOMMENDER), skip);
        HdfsSinkConnectorConfig.addAllConfigKeys(visible, PartitionerConfig.newConfigDef((ConfigDef.Recommender)PARTITIONER_CLASS_RECOMMENDER), skip);
        HdfsSinkConnectorConfig.addAllConfigKeys(visible, HiveConfig.getConfig(), skip);
        visible.define("storage.class", ConfigDef.Type.CLASS, (Object)HdfsStorage.class.getName(), ConfigDef.Importance.HIGH, "The underlying storage layer.", "Storage", 1, ConfigDef.Width.NONE, "Storage Class", (ConfigDef.Recommender)STORAGE_CLASS_RECOMMENDER);
        visible.define("format.class", ConfigDef.Type.CLASS, (Object)AvroFormat.class.getName(), ConfigDef.Importance.HIGH, "The format class to use when writing data to the store.", "Connector", 1, ConfigDef.Width.NONE, "Format class", (ConfigDef.Recommender)FORMAT_CLASS_RECOMMENDER);
        visible.define("topics.dir", ConfigDef.Type.STRING, (Object)"topics", ConfigDef.Importance.HIGH, "Top level directory to store the data ingested from Kafka. Supports ``${topic}`` in the value, which will be replaced by the actual topic name. Supports ``${0}``, ..., ``${n}`` in conjunction with topic.capture.groups.regex. See topic.capture.groups.regex configuration documentation for details.", "Storage", 2, ConfigDef.Width.NONE, "Topics directory");
        return visible;
    }

    private static void addAllConfigKeys(ConfigDef container, ConfigDef other, Set<String> skip) {
        for (ConfigDef.ConfigKey key : other.configKeys().values()) {
            if (skip == null || skip.contains(key.name)) continue;
            container.define(key);
        }
    }

    public int getTaskId() {
        return this.taskId;
    }

    public boolean hiveIntegrationEnabled() {
        return this.getBoolean("hive.integration");
    }

    public String hiveDatabase() {
        return this.getString("hive.database");
    }

    public Class<? extends HdfsStorage> storageClass() {
        return this.getClass("storage.class");
    }

    public static void main(String[] args) {
        System.out.println(HdfsSinkConnectorConfig.getConfig().toEnrichedRst());
    }

    static {
        STORAGE_CLASS_RECOMMENDER.addValidValues(Arrays.asList(HdfsStorage.class));
        FORMAT_CLASS_RECOMMENDER.addValidValues(Arrays.asList(AvroFormat.class, JsonFormat.class, OrcFormat.class, ParquetFormat.class, StringFormat.class));
        PARTITIONER_CLASS_RECOMMENDER.addValidValues(Arrays.asList(DefaultPartitioner.class, HourlyPartitioner.class, DailyPartitioner.class, TimeBasedPartitioner.class, FieldPartitioner.class));
    }

    private static class BooleanParentRecommender
    implements ConfigDef.Recommender {
        protected String parentConfigName;

        public BooleanParentRecommender(String parentConfigName) {
            this.parentConfigName = parentConfigName;
        }

        public List<Object> validValues(String name, Map<String, Object> connectorConfigs) {
            return new LinkedList<Object>();
        }

        public boolean visible(String name, Map<String, Object> connectorConfigs) {
            return (Boolean)connectorConfigs.get(this.parentConfigName);
        }
    }
}

