/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.storage.format.SchemaFileReader;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.hadoop.fs.Path;
import org.apache.kafka.connect.errors.DataException;

public class AvroFileReader
implements SchemaFileReader<HdfsSinkConnectorConfig, Path> {
    private AvroData avroData;

    public AvroFileReader(AvroData avroData) {
        this.avroData = avroData;
    }

    public org.apache.kafka.connect.data.Schema getSchema(HdfsSinkConnectorConfig conf, Path path) {
        try {
            FsInput input = new FsInput(path, conf.getHadoopConfiguration());
            GenericDatumReader reader = new GenericDatumReader();
            FileReader fileReader = DataFileReader.openReader((SeekableInput)input, (DatumReader)reader);
            Schema schema = fileReader.getSchema();
            fileReader.close();
            return this.avroData.toConnectSchema(schema);
        }
        catch (IOException e) {
            throw new DataException((Throwable)e);
        }
    }

    public boolean hasNext() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Iterator<Object> iterator() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

