/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.avro.AvroFileReader;
import io.confluent.connect.hdfs.avro.AvroHiveFactory;
import io.confluent.connect.hdfs.avro.AvroRecordWriterProvider;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.storage.format.Format;
import io.confluent.connect.storage.format.RecordWriterProvider;
import io.confluent.connect.storage.format.SchemaFileReader;
import io.confluent.connect.storage.hive.HiveFactory;
import org.apache.hadoop.fs.Path;

public class AvroFormat
implements Format<HdfsSinkConnectorConfig, Path> {
    private final HdfsStorage storage;
    private final AvroData avroData;

    public AvroFormat(HdfsStorage storage) {
        this.storage = storage;
        this.avroData = new AvroData(storage.conf().avroDataConfig());
    }

    public RecordWriterProvider<HdfsSinkConnectorConfig> getRecordWriterProvider() {
        return new AvroRecordWriterProvider(this.storage, this.avroData);
    }

    public SchemaFileReader<HdfsSinkConnectorConfig, Path> getSchemaFileReader() {
        return new AvroFileReader(this.avroData);
    }

    public HiveFactory getHiveFactory() {
        return new AvroHiveFactory(this.avroData);
    }
}

