/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.hive.HiveMetaStore;
import io.confluent.connect.hdfs.hive.HiveUtil;
import io.confluent.connect.hdfs.partitioner.Partitioner;
import io.confluent.connect.storage.errors.HiveMetaStoreException;
import io.confluent.connect.storage.hive.HiveSchemaConverter;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class AvroHiveUtil
extends HiveUtil {
    private static final String AVRO_SERDE = "org.apache.hadoop.hive.serde2.avro.AvroSerDe";
    private static final String AVRO_INPUT_FORMAT = "org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat";
    private static final String AVRO_OUTPUT_FORMAT = "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat";
    private static final String AVRO_SCHEMA_LITERAL = "avro.schema.literal";
    private final AvroData avroData;
    private final HdfsSinkConnectorConfig config;

    public AvroHiveUtil(HdfsSinkConnectorConfig conf, AvroData avroData, HiveMetaStore hiveMetaStore) {
        super(conf, hiveMetaStore);
        this.avroData = avroData;
        this.config = conf;
    }

    @Override
    public void createTable(String database, String tableName, Schema schema, Partitioner partitioner, String topic) throws HiveMetaStoreException {
        Table table = this.constructAvroTable(database, tableName, schema, partitioner, topic);
        this.hiveMetaStore.createTable(table);
    }

    public void alterSchema(String database, String tableName, Schema schema) throws HiveMetaStoreException {
        Table table = this.hiveMetaStore.getTable(database, tableName);
        Schema filteredSchema = this.excludePartitionFieldsFromSchema(schema, table.getPartitionKeys());
        table.getParameters().put(AVRO_SCHEMA_LITERAL, this.avroData.fromConnectSchema(filteredSchema).toString());
        this.hiveMetaStore.alterTable(table);
    }

    private Table constructAvroTable(String database, String tableName, Schema schema, Partitioner partitioner, String topic) throws HiveMetaStoreException {
        Table table = this.newTable(database, tableName);
        table.setTableType(TableType.EXTERNAL_TABLE);
        table.getParameters().put("EXTERNAL", "TRUE");
        String tablePath = this.hiveDirectoryName(this.url, this.config.getTopicsDirFromTopic(topic), topic);
        table.setDataLocation(new Path(tablePath));
        table.setSerializationLib(AVRO_SERDE);
        try {
            table.setInputFormatClass(AVRO_INPUT_FORMAT);
            table.setOutputFormatClass(AVRO_OUTPUT_FORMAT);
        }
        catch (HiveException e) {
            throw new HiveMetaStoreException("Cannot find input/output format:", (Throwable)e);
        }
        Schema filteredSchema = this.excludePartitionFieldsFromSchema(schema, partitioner.partitionFields());
        List columns = HiveSchemaConverter.convertSchema((Schema)filteredSchema);
        table.setFields(columns);
        table.setPartCols(partitioner.partitionFields());
        table.getParameters().put(AVRO_SCHEMA_LITERAL, this.avroData.fromConnectSchema(filteredSchema).toString());
        return table;
    }

    private Schema excludePartitionFieldsFromSchema(Schema originalSchema, List<FieldSchema> partitionFields) {
        Set partitions = partitionFields.stream().map(FieldSchema::getName).collect(Collectors.toSet());
        SchemaBuilder newSchema = SchemaBuilder.struct();
        for (Field field : originalSchema.fields()) {
            if (partitions.contains(field.name())) continue;
            newSchema.field(field.name(), field.schema());
        }
        return newSchema;
    }
}

