/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.hdfs.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.hdfs.HdfsSinkConnectorConfig;
import io.confluent.connect.hdfs.storage.HdfsStorage;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroRecordWriterProvider
implements RecordWriterProvider<HdfsSinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(AvroRecordWriterProvider.class);
    private static final String EXTENSION = ".avro";
    private final HdfsStorage storage;
    private final AvroData avroData;

    AvroRecordWriterProvider(HdfsStorage storage, AvroData avroData) {
        this.storage = storage;
        this.avroData = avroData;
    }

    public String getExtension() {
        return EXTENSION;
    }

    public RecordWriter getRecordWriter(final HdfsSinkConnectorConfig conf, final String filename) {
        return new RecordWriter(){
            final DataFileWriter<Object> writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
            org.apache.kafka.connect.data.Schema schema;

            public void write(SinkRecord record) {
                if (this.schema == null) {
                    this.schema = record.valueSchema();
                    try {
                        log.info("Opening record writer for: {}", (Object)filename);
                        OutputStream out = AvroRecordWriterProvider.this.storage.create(filename, true);
                        Schema avroSchema = AvroRecordWriterProvider.this.avroData.fromConnectSchema(this.schema);
                        this.writer.setCodec(CodecFactory.fromString((String)conf.getAvroCodec()));
                        this.writer.create(avroSchema, out);
                    }
                    catch (IOException e) {
                        throw new ConnectException((Throwable)e);
                    }
                }
                log.trace("Sink record: {}", (Object)record);
                Object value = AvroRecordWriterProvider.this.avroData.fromConnectData(this.schema, record.value());
                try {
                    if (value instanceof NonRecordContainer) {
                        this.writer.append(((NonRecordContainer)value).getValue());
                    } else {
                        this.writer.append(value);
                    }
                }
                catch (IOException e) {
                    throw new DataException((Throwable)e);
                }
            }

            public void close() {
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    throw new DataException((Throwable)e);
                }
            }

            public void commit() {
            }
        };
    }
}

